% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{load_data}
\alias{load_data}
\title{Load and format data object}
\usage{
load_data(
  time,
  event,
  vacc,
  marker,
  covariates,
  weights,
  ph2,
  strata = NA,
  data,
  covariates_ph2 = FALSE
)
}
\arguments{
\item{time}{A character string; the name of the numeric variable representing
observed event or censoring times.}

\item{event}{A character string; the name of the binary variable
corresponding to whether the observed time represents an event time (1)
or a censoring time (0). Either integer (0/1) or Boolean (T/F) values are
allowed.}

\item{vacc}{A character string; the name of the binary variable denoting
whether the individual is in the vaccine group (1) or the placebo group
(0). Accepts either integer (0/1) or Boolean (T/F) values.}

\item{marker}{A character string; the name of the numeric variable of
biomarker values.}

\item{covariates}{A character vector; the names of the covariate columns.
Columns values should be either numeric, binary, or factors. Character
columns will be converted into factors.}

\item{weights}{A character string; the name of the numeric variable
containing inverse-probability-of-sampling (IPS) weights.}

\item{ph2}{A character string; the name of the binary variable representing
whether the individual is in the phase-two cohort (1) or not (0). Accepts
either integer (0/1) or Boolean (T/F) values.}

\item{strata}{A character string; the name of the variable containing strata
identifiers (for two-phase sampling strata).}

\item{data}{A dataframe containing the vaccine trial data.}

\item{covariates_ph2}{A boolean; if at least one of the covariates is
measured only in the phase-two cohort, set this to TRUE.}
}
\value{
An object of class \code{vaccine_dat}.
}
\description{
This function takes in user-supplied data and returns a data
    object that can be read in by \code{\link{summary_stats}},
    \code{\link{est_ce}}, \code{\link{est_med}}, and other estimation
    functions. Data is expected to come from a vaccine clinical trial,
    possibly involving two-phase sampling and possibly including a biomarker
    of interest.
}
\examples{
data(hvtn505)
dat <- load_data(time="HIVwk28preunblfu", event="HIVwk28preunbl", vacc="trt",
                 marker="IgG_V2", covariates=c("age","BMI","bhvrisk"),
                 weights="wt", ph2="casecontrol", data=hvtn505)
}
