% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\name{vascr_summarise}
\alias{vascr_summarise}
\title{Summarise a vascr data set down to a particular level}
\usage{
vascr_summarise(data.df, level = "wells")
}
\arguments{
\item{data.df}{Data set to summarize}

\item{level}{Level to summarise to, either "median_deviation", "ANOVA", "summary", "experiment" or "wells"}
}
\value{
The summarized data set
}
\description{
Summarise a vascr data set down to a particular level
}
\examples{
rbgrowth.df = vascr_subset(growth.df, unit = "Rb")

vascr_summarise(rbgrowth.df, level = "summary")
vascr_summarise(rbgrowth.df, level = "experiment")
vascr_summarise(rbgrowth.df, level = "wells")
}
