% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server_manager.R, R/vault_server_instance.R
\name{vault_test_server}
\alias{vault_test_server}
\alias{vault_server_instance}
\title{Control a test vault server}
\usage{
vault_test_server(
  https = FALSE,
  init = TRUE,
  if_disabled = testthat::skip,
  quiet = FALSE
)
}
\arguments{
\item{https}{Logical scalar, indicating if a https-using server
should be created, rather than the default vault dev-mode
server.  This is still \emph{entirely} insecure, and uses self
signed certificates that are bundled with the package.}

\item{init}{Logical scalar, indicating if the https-using server
should be initialised.}

\item{if_disabled}{Callback function to run if the vault server is
not enabled.  The default, designed to be used within tests, is
\code{testthat::skip}.  Alternatively, inspect the
\verb{$enabled} property of the returned object.}

\item{quiet}{Logical, indicating if startup should be quiet and
not print messages}
}
\description{
Control a server for use with testing.  This is designed to be
used only by other packages that wish to run tests against a vault
server.  You will need to set \code{VAULTR_TEST_SERVER_BIN_PATH} to
point at the directory containing the vault binary, to the binary
itself, or to the value \code{auto} to try and find it on your \code{PATH}.
}
\details{
Once created with \code{vault_test_server}, a server will stay
alive for as long as the R process is alive \emph{or} until the
\code{vault_server_instance} object goes out of scope and is
garbage collected.  Calling \verb{$kill()} will explicitly stop
the server, but this is not strictly needed.  See below for
methods to control the server instance.
}
\section{Warning}{


Starting a server in test mode must \emph{not} be used for production
under any circumstances.  As the name suggests,
\code{vault_test_server} is a server suitable for \emph{tests} only and
lacks any of the features required to make vault secure.  For
more information, please see the the official Vault
documentation on development servers:
https://developer.hashicorp.com/vault/docs/concepts/dev-server
}

\examples{

# Try and start a server; if one is not enabled (see details
# above) then this will return NULL
server <- vault_test_server(if_disabled = message)

if (!is.null(server)) {
  # We now have a server running on an arbitrary high port - note
  # that we are running over http and in dev mode: this is not at
  # all suitable for production use, just for tests
  server$addr

  # Create clients using the client method - by default these are
  # automatically authenticated against the server
  client <- server$client()
  client$write("/secret/password", list(value = "s3cret!"))
  client$read("/secret/password")

  # The server stops automatically when the server object is
  # garbage collected, or it can be turned off with the
  # 'kill' method:
  server$kill()
  tryCatch(client$status(), error = function(e) message(e$message))
}
}
\section{Super class}{
\code{\link[vaultr:vault_client_object]{vaultr::vault_client_object}} -> \code{vault_server_instance}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{port}}{The vault port (read-only).}

\item{\code{addr}}{The vault address; this is suitable for using with
\link{vault_client} (read-only).}

\item{\code{token}}{The vault root token, from when the testing vault
server was created.  If the vault is rekeyed this will no
longer be accurate (read-only).}

\item{\code{keys}}{Key shares from when the vault was initialised
(read-only).}

\item{\code{cacert}}{Path to the https certificate, if running in
https mode (read-only).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-vault_server_instance-new}{\code{vault_server_instance$new()}}
\item \href{#method-vault_server_instance-version}{\code{vault_server_instance$version()}}
\item \href{#method-vault_server_instance-client}{\code{vault_server_instance$client()}}
\item \href{#method-vault_server_instance-env}{\code{vault_server_instance$env()}}
\item \href{#method-vault_server_instance-export}{\code{vault_server_instance$export()}}
\item \href{#method-vault_server_instance-clear_cached_token}{\code{vault_server_instance$clear_cached_token()}}
\item \href{#method-vault_server_instance-kill}{\code{vault_server_instance$kill()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="format"><a href='../../vaultr/html/vault_client_object.html#method-vault_client_object-format'><code>vaultr::vault_client_object$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="vaultr" data-topic="vault_client_object" data-id="help"><a href='../../vaultr/html/vault_client_object.html#method-vault_client_object-help'><code>vaultr::vault_client_object$help()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_server_instance-new"></a>}}
\if{latex}{\out{\hypertarget{method-vault_server_instance-new}{}}}
\subsection{Method \code{new()}}{
Create a \code{vault_server_instance} object. Not typically
called by users.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_server_instance$new(bin, port, https, init, quiet = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bin}}{Path to the vault binary}

\item{\code{port}}{Port to use}

\item{\code{https}}{Logical, indicating if we should use TLS/https}

\item{\code{init}}{Logical, indicating if we should initialise}

\item{\code{quiet}}{Logical, indicating if startup should be quiet}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_server_instance-version"></a>}}
\if{latex}{\out{\hypertarget{method-vault_server_instance-version}{}}}
\subsection{Method \code{version()}}{
Return the server version, as a \link{numeric_version}
object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_server_instance$version()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_server_instance-client"></a>}}
\if{latex}{\out{\hypertarget{method-vault_server_instance-client}{}}}
\subsection{Method \code{client()}}{
Create a new client that can use this server.  The
client will be a \link{vault_client} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_server_instance$client(login = TRUE, quiet = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{login}}{Logical, indicating if the client should login to
the server (default is \code{TRUE}).}

\item{\code{quiet}}{Logical, indicating if informational messages
should be suppressed.  Default is \code{TRUE}, in contrast with
most other methods.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_server_instance-env"></a>}}
\if{latex}{\out{\hypertarget{method-vault_server_instance-env}{}}}
\subsection{Method \code{env()}}{
Return a named character vector of environment
variables that can be used to communicate with this vault
server (\code{VAULT_ADDR}, \code{VAULT_TOKEN}, etc).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_server_instance$env()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_server_instance-export"></a>}}
\if{latex}{\out{\hypertarget{method-vault_server_instance-export}{}}}
\subsection{Method \code{export()}}{
Export the variables returned by the \verb{$env()}
method to the environment.  This makes them available to
child processes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_server_instance$export()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_server_instance-clear_cached_token"></a>}}
\if{latex}{\out{\hypertarget{method-vault_server_instance-clear_cached_token}{}}}
\subsection{Method \code{clear_cached_token()}}{
Clear any session-cached token for this server.
This is intended for testing new authentication backends.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_server_instance$clear_cached_token()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-vault_server_instance-kill"></a>}}
\if{latex}{\out{\hypertarget{method-vault_server_instance-kill}{}}}
\subsection{Method \code{kill()}}{
Kill the server.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{vault_server_instance$kill()}\if{html}{\out{</div>}}
}

}
}
