% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrate_double_xy.R
\name{integrate_double_xy}
\alias{integrate_double_xy}
\title{Unified Numerical Double Integration}
\usage{
integrate_double_xy(
  f,
  const_min,
  const_max,
  limit1,
  limit2,
  region_type = "type1",
  n_outer = 100,
  n_inner = 100,
  plot_domain = TRUE
)
}
\arguments{
\item{f}{A function in R of two variables, f(x, y), returning a numeric value.}

\item{const_min}{The constant lower limit of the outer integration (a for Type I, c for Type II).}

\item{const_max}{The constant upper limit of the outer integration (b for Type I, d for Type II).}

\item{limit1}{A function in R of one variable defining the inner integral's lower limit (h1(x) or h1(y)).}

\item{limit2}{A function in R of one variable defining the inner integral's upper limit (h2(x) or h2(y)).}

\item{region_type}{A string specifying the region type: "type1" (dy dx) or "type2" (dx dy). Default is "type1".}

\item{n_outer}{Number of subintervals for the outer integration. Must be even. Default is 100.}

\item{n_inner}{Number of subintervals for the inner integration. Must be even. Default is 100.}

\item{plot_domain}{Logical. If TRUE, generates a ggplot2 plot of the integration domain. Default is TRUE.}
}
\value{
A list containing:
\itemize{
\item \code{integral_value}: The calculated approximation of the integral.
\item \code{domain_plot}: The ggplot2 object representing the domain (if plot_domain = TRUE).
}
}
\description{
Calculates the definite double integral of a function f(x, y) over a
general region D, which can be defined as Type I (dy dx) or Type II (dx dy).
Uses the Composite Simpson's Rule for numerical approximation.
}
