% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secant_tangent.R
\name{secant_tangent}
\alias{secant_tangent}
\title{Secant lines converge to the tangent line (Plotly)}
\usage{
secant_tangent(
  f,
  x0,
  h_vals = NULL,
  method = c("forward", "central"),
  xlim = NULL,
  n_curve = 400L,
  frame_ms = 220L,
  transition_ms = 220L,
  title = NULL,
  safe_mode = TRUE
)
}
\arguments{
\item{f}{Function. A real-valued function f(x). It must accept a numeric
vector and return a numeric vector of the same length.}

\item{x0}{Numeric scalar. Point where the derivative is approximated.}

\item{h_vals}{Numeric vector. Positive step sizes used as animation frames.
If NULL, a default decreasing sequence is used.}

\item{method}{Character. Derivative approximation method:
"forward" (default) or "central".}

\item{xlim}{Numeric vector of length 2. Plot range for x. If NULL, it is
chosen automatically from x0 and h_vals.}

\item{n_curve}{Integer. Number of points used to draw the curve and lines.}

\item{frame_ms}{Integer. Frame duration in milliseconds.}

\item{transition_ms}{Integer. Transition duration in milliseconds.}

\item{title}{Character. Plot title. If NULL, a default title is used.}

\item{safe_mode}{Logical. If TRUE, use calmer animation defaults intended to
reduce flicker and visual stress.}
}
\value{
A list with components:
\describe{
\item{plot}{A plotly object (htmlwidget) with animation frames.}
\item{derivative}{Numeric scalar. Derivative estimate using the smallest h.}
\item{data}{Data frame used for the animated secant lines (useful for debugging).}
}
}
\description{
Approximates the derivative of a function at a point numerically and builds
an interactive Plotly animation showing how secant (incremental quotient)
lines converge to the tangent line as the step size decreases. The secant
point(s) used for the slope computation are also animated.
}
\details{
The forward incremental quotient is
\deqn{
  m_h = \frac{f(x_0+h)-f(x_0)}{h}.
}
The central difference approximation is
\deqn{
  m_h = \frac{f(x_0+h)-f(x_0-h)}{2h}.
}
The tangent line model at x0 is
\deqn{
  y = f(x_0) + f'(x_0)\,(x-x_0).
}
}
\examples{
\donttest{
library(plotly)

f <- function(x) x^2
out <- secant_tangent(f, x0 = 1)
out$plot
out$derivative

g <- function(x) sin(x)
secant_tangent(g, x0 = 0.7, method = "central", h_vals = 2^(-(1:7)))
}

}
