% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.r
\encoding{UTF-8}
\name{encode_shape}
\alias{encode_shape}
\title{Encode shape "channel"}
\usage{
encode_shape(vl, field = NULL, type, value = NULL, aggregate = NULL,
  sort = NULL)
}
\arguments{
\item{vl}{Vega-Lite object created by \code{\link{vegalite}}}

\item{field}{single element character vector naming the column}

\item{type}{the encoded field’s type of measurement. This can be either a full type
name (\code{quantitative}, \code{temporal}, \code{ordinal}, and \code{nominal})
or an initial character of the type name (\code{Q}, \code{T}, \code{O}, \code{N}).
This property is case insensitive. If \code{auto} is used, the type will
be guessed (so you may want to actually specify it if you want consistency).}

\item{value}{scale value}

\item{aggregate}{perform aggregaton on \code{field}. See
\href{http://vega.github.io/vega-lite/docs/aggregate.html}{Supported Aggregation Options} for
more info on valid operations. Leave \code{NULL} for no aggregation.}

\item{sort}{either one of \code{ascending}, \code{descending} or (for ordinal scales)
the result of a call to \code{\link{sort_def}}}
}
\description{
Encode shape "channel"
}
\note{
right now, \code{type} == "\code{auto}" just assume "\code{quantitative}". It
      will eventually get smarter, but you are better off specifying it.
}
\examples{
vegalite() \%>\%
  add_data("https://vega.github.io/vega-editor/app/data/cars.json") \%>\%
  encode_x("Horsepower", "quantitative") \%>\%
  encode_y("Miles_per_Gallon", "quantitative") \%>\%
  encode_color("Origin", "nominal") \%>\%
  encode_shape("Origin", "nominal") \%>\%
  mark_point()
}
\references{
\href{http://vega.github.io/vega-lite/docs/encoding.html}{Vega-Lite Encoding spec}
}

