# TO DO: add moment correction terms.
pdpropper <- function( x, n, p = NULL, lambda = c( -2, -1, -1/2, 0, 2/3, 1 ),
			alternative = c( "two.sided", "less", "greater" ),
			alpha = 0.05, correct = FALSE ) {

    DNAME <- deparse1(substitute(x))
    if( is.table(x) && length(dim(x)) == 1L ) {

        if( dim(x) != 2L ) stop( "table 'x' should have two entries." )
	l <- 1
	N <- sum(x)
	x <- x[1L]

    } else if( is.matrix(x) ) {

        if( ncol(x) != 2L ) stop( "'x' must have 2 columns." )
	l <- nrow( x )
	n <- rowSums(x)
	x <- x[, 1L]

    } else {

        DNAME <- paste( DNAME, "out of", deparse1(substitute(n)))
	l <- length(x)
	if( length(n) == 1 ) n <- rep( n, l )
	if( l != length(n) ) stop( "'x' and 'n' must have the same length." )

    }

    OK <- complete.cases(x, n)
    x <- x[OK]
    n <- n[OK]
    if( (k <- length(x)) < 1L) stop( "not enough data" )
    if( any( n <= 0 ) ) stop( "elements of 'n' must be positive" )
    if( any( x < 0 ) ) stop( "elements of 'x' must be nonnegative" )
    if( any( x > n ) ) stop( "elements of 'x' must not be greater than those of 'n'" )
    if( is.null(p) && (k==1)) p <- 0.5
    if( !is.null(p) ) {

	DNAME <- paste0(DNAME, ", null ", if( k == 1 ) "probability"
				else "probabilities ", deparse1(substitute(p)) )

	p <- p[OK]
	if( any((p <= 0) | ( p >= 1) ) ) stop( "elements of 'p' must be in (0,1)")

    } # end of if 'p' is null stmts.

    alternative <- match.arg(alternative)
    if( k > 2 || (k == 2) && !is.null(p) ) alternative <- "two.sided"
    ESTIMATE <- setNames( x/n, if( k == 1 ) "p"
    				else paste( "prop", 1L:l )[OK] )

    NVAL <- p

    if( is.null(p) ) {

        p <- sum(x)/sum(n)
	PARAMETER <- k - 1

    } else  {
    
        PARAMETER <- k
	names(NVAL) <- names(ESTIMATE)

    } # end of if else 'p' is null stmt.

    names( PARAMETER ) <- "df"

    x <- cbind( x, n - x )
    E <- cbind( n * p, n * (1 - p) )


    if( length( lambda ) == 1 ) {

        return( pdpropperWork( x = x, n = n, p = p, lambda = lambda, k = k,
			ESTIMATE = ESTIMATE, E = E, PARAMETER = PARAMETER, NVAL = NVAL,
			alternative = alternative, correct = correct, DNAME = DNAME ) )

    } else {

        res <- list()
	for( i in 1:length( lambda ) ) {

	    res[[ i ]] <- pdpropperWork( x = x, n = n, p = p, lambda = lambda[i], k = k,
	    			    ESTIMATE = ESTIMATE, E = E, PARAMETER = PARAMETER, NVAL = NVAL,
				    alternative = alternative, correct = correct, DNAME = DNAME )

	} # end of for 'i' loop.

	out <- list( results = res, lambda = lambda, call = call )
	class( out ) <- "powerdiverged"
	return( out )

    } # end of if 'lambda' is a vector or not stmt.

    
} # end of 'pdpropper' function.

pdpropperWork <- function( x, n, p, lambda, k, ESTIMATE, E, PARAMETER, NVAL = NULL,
			alternative, alpha, correct, DNAME ) {

    if( lambda == -1 ) STATISTIC <- 2 * sum( E * log( E / x ) )
    else if( lambda == 0 ) STATISTIC <- 2 * sum( x * log( x / E ) )
    else STATISTIC <- ( 2 / ( lambda * (1 + lambda) ) ) * sum( x * ( ( x / E )^lambda - 1 ) )

    if( lambda == -2 ) METHOD <- "Neyman modified chi-square"
    else if( lambda == -1 ) METHOD <- "Kullbak-Leibler"
    else if( lambda == -0.5 ) METHOD <- "Freeman-Tukey"
    else if( lambda == 0 ) METHOD <- "likelihood-ratio"
    else if( lambda == 2/3 ) METHOD <- "Cressie-Read"
    else if( lambda == 1 ) METHOD <- "Pearson chi-square"
    else METHOD <- paste( "Power-divergence with lambda =", lambda )
    if( correct ) METHOD <- paste( METHOD, "with mean correction" )
    names( STATISTIC ) <- METHOD 

    METHOD <- paste(if (k == 1) "1-sample proportions test"
	            else paste0(k, "-sample test for ", if (is.null(p)) "equality of"
			    				else "given", " proportions"),
		    if ( correct ) "with"
		    else "without", "moment correction")

    if( correct ) {

	if( k == 1 ) warning( "correct is TRUE but df not k-1 so correction may be invalid." )
	tau <- sum( 1 / p )
	fm <- (lambda - 1) * (2 - 3 * k + tau) / 3 + (lambda - 1) * (lambda - 2) * (1 - 2*k + tau) / 4
	fv <- 2 - 2*k - k^2 + tau + (lambda - 1)*(8 - 12*k - 2*k^2 + 6*tau ) +
		(lambda - 1)^2*(4 - 6*k - 3*k^2 + 5*tau)/3 + (lambda - 1)*(lambda - 2) *(2 - 4*k + 2*tau)
	sigmalam <- 1 + fv/(2 * (k-1)*n)
	mulam <- (k-1)*(1-sigmalam) + fm/n
	STATISTIC <- (STATISTIC - mulam)/sigmalam

	} # end of if 'correct' stmt.

    if( alternative == "two.sided" ) PVAL <- pchisq( STATISTIC, PARAMETER, lower.tail = FALSE )
    else {

        if (k == 1) z <- sign(ESTIMATE - p) * sqrt(STATISTIC)
	else z <- sign( ESTIMATE[1L] - ESTIMATE[2L] ) * sqrt(STATISTIC)
	PVAL <- pnorm(z, lower.tail = (alternative == "less"))

    } # end of if else 'two.sided' alternative stmts.

    RVAL <- list(statistic = STATISTIC, parameter = PARAMETER, 
		p.value = as.numeric(PVAL), estimate = ESTIMATE, null.value = NVAL, 
		alternative = alternative, method = METHOD, 
		data.name = DNAME)

    class( RVAL ) <- "htest"
    return( RVAL )

} # end of 'pdpropperWork' function.
