% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VirtualArray-subset.R
\name{[[,VirtualArray,ANY,ANY-method}
\alias{[[,VirtualArray,ANY,ANY-method}
\alias{[[,VirtualArray-method}
\title{Indexing to extract the elements of a '\code{\link[via:XArray-class]{VirtualArray}}'-derived class object.}
\usage{
\S4method{[[}{VirtualArray,ANY,ANY}(x, i, drop = TRUE)
}
\arguments{
\item{x}{\code{\link[via:XArray-class]{VirtualArray}}}

\item{i}{subscript of the first dimension(rows) or vector-like subsetting.}

\item{drop}{\code{logical} should the \code{\link[via:XArray-class]{VirtualArray}} be dropped and the element be reduced to the element class?}
}
\value{
A \code{\link[via:XArray-class]{VirtualArray}}-derived class object, or an object of the class that makes up the VirtualArray
}
\description{
Double bracket \code{'[['} refers to elements'/layers' name in the \code{@stack} of the '\code{\link[via:XArray-class]{VirtualArray}}'-derived object. Use single brackets to extract elements based on their position in the '\code{\link[via:XArray-class]{VirtualArray}}'.
}
\examples{
data(exemplar)
# finds a layer
exemplar[["sample1"]]
# returns a stack
exemplar[[c("sample1", "sample2")]]
# replaces a layervalues, but not the attributes of the layer
exemplar2 <- exemplar
exemplar2[["sample1"]] <- exemplar2[["sample2"]]
# compare every value in the they are all the same
exemplar2[["sample1"]]$x == exemplar2[["sample2"]]$x
}
