% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plt.3dcm_best.R
\name{plt.3dcm_best}
\alias{plt.3dcm_best}
\title{Create a 3D Slice Plot of Correlation Array}
\usage{
plt.3dcm_best(R3, colorscale = "Spectral")
}
\arguments{
\item{R3}{A 3D numeric array of correlation coefficients.}

\item{colorscale}{A character string specifying the colorscale to use. If \code{"Spectral"}, a custom
colorscale is created using \code{colorRampPalette(rev(RColorBrewer::brewer.pal(11, "Spectral")), space = "Lab")(100)}.
Otherwise, the provided value is used (default is \code{"Spectral"}).}
}
\value{
An interactive Plotly figure showing three surfaces corresponding to constant slices along dimensions i, j, and k.
}
\description{
This function creates an interactive Plotly 3D slice plot from a 3D correlation array.
The function uses the array's dimnames to define the coordinate values. If no dimnames are present,
a warning is issued and sequential indices are used. The plot displays three surfaces corresponding
to slices along each dimension (i, j, k) at the best band combination (where the correlation value is maximal).
}
\details{
The function first checks if the input 3D array has proper dimnames. If not, it issues a warning
and assigns sequential indices as dimnames. It then melts the array to find the best band combination based on the
maximum correlation value. Using the dimnames, it finds the numeric indices for the best bands and creates grid matrices
for each slice. A custom colorscale is built when \code{colorscale = "Spectral"}, and the Plotly figure is constructed
with a single color bar.
}
\examples{
\dontrun{
  # Assume cm3d is a 3D correlation array with proper dimnames.
  plt.3dcm_best(cm3d)
}

}
