% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jansonius.R
\name{cart2jpolar}
\alias{cart2jpolar}
\alias{jpolar2cart}
\alias{bundlePath}
\alias{loc2psi}
\alias{psi2oct}
\alias{vf2gc}
\title{The Jansonius map for average path of nerve fiber bundles}
\usage{
cart2jpolar(coord)

jpolar2cart(rpsi)

bundlePath(psi0, r0 = 4)

loc2psi(coord, r0 = 4)

psi2oct(psi0, diam = 12)

vf2gc(coord, angle = 0)
}
\arguments{
\item{coord}{coordinates of locations in the visual field}

\item{rpsi}{visual field locations in polar coordinates of the
distorted space of the Jansonius map}

\item{psi0}{angle of incidence at the ONH}

\item{r0}{radius of the ONH. Its default value is \code{4}.
Changing it changes the calculated average bundle paths.}

\item{diam}{diamater in degrees of visual angle of the OCT circular
scan centered at the center of the ONH}

\item{angle}{fovea-disc angle in degrees}
}
\value{
\code{cart2jpolar}: returns the Jansonius modified polar coordinates

\code{jpolar2cart}: returns Cartesian coordinates

\code{bundlePath}: returns a function describing a retinal ganglion cell bundle path

\code{loc2psi}: returns the angle of incidence on the ONH

\code{psi2oct}: returns the corresponding angle in the OCT circular scan

\code{vf2gc}: returns the ganglion cell soma corresponding to the photoreceptors
                      of a visual field location
}
\description{
Generates a function that renders the average path of
a nerve fiber bundle that exits through the optic nerve head (ONH)
with a particular angle
}
\details{
\itemize{
  \item\code{cart2jpolar} converts the cartesian coordinates to the polar
    coordinates in the distorted space used in the Jansonius map
  \item\code{jpolar2cart} converts back from the Jansonius polar
    coordinates to cartesian coordinates
  \item\code{bundlePath} returns a function describing the expected fiber
    path given an angle of incidence on the ONH
  \item\code{loc2psi} returns the angle of incidence of the average bundle path
    that passes through specific locations of the visual field
  \item\code{psi2oct} returns the angle of OCT circular scans corresponding
    to average bundle paths with specific angle of incidence at the ONH
  \item\code{vf2gc} calculates ganglion-cell soma locations
}
}
\examples{
# get ganglion-cell soma locations from visual field locations
vf2gc(locmaps$p10d2$coord)
# convert to polar of the distorted space used by Jansonius map and back
coord <- data.frame(x = c(3, 0, -3), y = c(0, 0, 0))
(rpsi <- cart2jpolar(coord))
jpolar2cart(rpsi)

# get an average bundle path from a specific angle of incidence in the ONH
# The object returned is a function that returns polar angles of the
# distorted space of the Jansonius map for distances from the ONH center
pathFun <- bundlePath(-125)
jpolar2cart(data.frame(10:20, pathFun(10:20)))

# get angle of incidence in the ONH from locations of the visual field
loc2psi(coord)

# get the OCT circular scan angles from the angle of incidence in the ONH
# for the 10-2 map of locations, ...
psi2oct(loc2psi(locmaps$p10d2$coord))
# the previous operation was actually fundamentally wrong! We need to
# obtain first the 
psi2oct(loc2psi(vf2gc(locmaps$p10d2$coord)))
}
\references{
N. M. Jansonius, J. Nevalainen, B. Selig, L. M. Zangwill,
P. A. Sample, W. M. Budde, J. B. Jonas, W. A. Lagreze,
P. J. Airaksinen, R. Vonthein, L. A. Levin, J. Paetzold,
and U. Schiefer. \emph{A mathematical description of nerve
fiber bundle trajectories and their variability in the human
retina}. Vision Research, 49(17):2157-2163, 2009

N. M. Jansonius, J. Nevalainen, B. Selig, L. M. Zangwill,
P. A. Sample, W. M. Budde, J. B. Jonas, W. A. Lagreze,
P. J. Airaksinen, R. Vonthein, L. A. Levin, J. Paetzold,
and U. Schiefer. \emph{Erratum to "A mathematical description
of nerve fiber bundle trajectories and their variability in
the human retina"}. Vision Research, 50:1501, 2010

N. M. Jansonius, J. Schiefer, J. Nevalainen, J. Paetzold,
and U. Schiefer. \emph{A mathematical model for describing
the retinal nerve fiber bundle trajectories in the human eye:
Average course, variability, and influence of refraction, optic
disc size and optic disc position}. Experimental Eye Research,
105:70-78, 2012

N. Drasdo, C. L. Millican, C. R. Katholi, and C. A. Curcio. \emph{The
length of Henle fibers in the human retina and a model of ganglion
receptive field density in the visual field}. Vision Research,
47:2901–2911, 2007

D. C. Hood, A. S. Raza, D. M. C. G. V., J. G. Odel, V. C. Greenstein,
J. M. Liebmann, and R. Ritch. \emph{Initial arcuate defects within the
central 10  degrees in glaucoma}. Investigative Ophthalmology and Visual
Science, 52(2):940-946, 2011

A. S. Raza, J. Cho, D. M. C. G. V., H. Wang, X. Zhang, R. H. Kardon,
J. M. Liebmann, R. Ritch, and D. C. Hood. \emph{Retinal ganglion cell
layer thickness and local visual field sensitivity in glaucoma}.
Archives of Ophthalmology, 129(12):1529-1536, 2011

G. Montesano, G. Ometto, R. E. Hogg, L. M. Rossetti, D. F. Garway-Heath,
and D. P. Crabb. \emph{Revisiting the Drasdo Model: Implications for 
Structure-Function Analysis of the Macular Region}. 
Translational Vision Science and Technology,
9(10):15, 2020
}
