\name{grid.offsetBezier}
\alias{grid.offsetBezier}
\alias{offsetBezierGrob}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Draw a Bezier Offset Curve.
}
\description{
  Draw a Bezier offset curve; the main curve is described
  by x/y control points and offset Bezier curves are calculated to the
  left and right of the main curve at the specified widths.
}
\usage{
offsetBezierGrob(x, y, w, default.units="npc", 
                 stepFn=nSteps(100), open=TRUE,
                 lineend="butt", linejoin="round", mitrelimit=4,
                 render=if (open) vwPolygon else vwPath(),
                 gp=gpar(fill="black"), name=NULL, debug=FALSE)
grid.offsetBezier(...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{A numeric vector or unit describing x-locations.}
  \item{y}{A numeric vector or unit describing y-locations.}
  \item{w}{A numeric vector or unit describing widths at each location,
    or a width specification generated by \code{\link{widthSpline}}
    or a width specification generated by \code{\link{BezierWidth}}.
  }
  \item{default.units}{The units used if \code{x} or \code{y} are
    numeric vectors.}
  \item{stepFn}{Function called to generate steps in \var{t}
    when rendering. See Details.}
  \item{open}{A boolean indicating whether to connect the last location
    back to the first location to produce a closed line.}
  \item{lineend}{The line ending style; one of \code{"round"},
    \code{"mitre"}, \code{"butt"}, \code{"square"}, or \code{"extend"}.}
  \item{linejoin}{The line join style; one of \code{"round"},
    \code{"mitre"}, \code{"bevel"}, or \code{"extend"}.}
  \item{mitrelimit}{A numeric that controls when a mitre join is
    converted to a bevel join or a mitre ending
    is converted to a square ending.}
  \item{render}{A function that is used to render the outline of the path
    that is generated for the variable-width line.}
  \item{gp}{A set of graphical parameters; see \code{\link{gpar}}.}
  \item{name}{A name for the grob generated for the variable-width
    line.}
  \item{debug}{A logical indicating whether to produce graphical
    debugging output.}
  \item{\dots}{
    Arguments passed to \code{offsetBezierGrob}.
  }
}
\details{
  Rendering relies on flattening the spline to a series of
  straight line segments.  This depends on generating a set
  of \var{t} values (and then \var{x} and \var{y} are calculated
  from \var{t}).  The \code{stepFn} is called to generate \var{t}
  and given the control
  points, \code{x} and \code{y} as arguments, plus a \code{range},
  which indicates what range of \var{t} to generate values for.
  
  The \code{"extend"} line ending and line join style is only
  available if the width is specified by \code{\link{BezierWidth}}.
}
\value{
  \code{grid.offsetBezier} is used for its side-effect of drawing a
  variable-width
  line;  \code{offsetBezierGrob} returns a \code{"offsetBezierGrob"} object.
}
\author{
  Paul Murrell
}
\seealso{
  \code{\link{grid.xspline}},
  \code{\link{grid.vwline}},
  \code{\link{grid.vwcurve}},
  \code{\link{grid.brushXspline}},
  \code{\link{grid.vwXspline}},
  \code{\link{grid.offsetXspline}}
}
\examples{
grid.newpage()
x <- c(.2, .4, .6, .8)
y <- c(-.05, .05, -.05, .05)
w <- unit(c(2, 4, 6, 8), "mm")
grid.offsetBezier(x, y + .8, w)
grid.offsetBezier(x, y + .5, w,
                  lineend="round")
grid.offsetBezier(x, y + .2, w,
                  gp=gpar(col="black"), debug=TRUE)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ aplot }% use one of  RShowDoc("KEYWORDS")
