// Generated by rstantools.  Do not edit by hand.

/*
    walker is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    licence is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with licence.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_rw1_model_naive_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 45> locations_array__ =
  {" (found before start of program)",
  " (in 'string', line 18, column 2 to column 33)",
  " (in 'string', line 19, column 2 to column 24)",
  " (in 'string', line 20, column 2 to column 24)",
  " (in 'string', line 23, column 2 to column 20)",
  " (in 'string', line 25, column 2 to column 16)",
  " (in 'string', line 26, column 2 to column 51)",
  " (in 'string', line 28, column 4 to column 24)",
  " (in 'string', line 29, column 4 to column 58)",
  " (in 'string', line 27, column 16 to line 30, column 3)",
  " (in 'string', line 27, column 2 to line 30, column 3)",
  " (in 'string', line 33, column 2 to column 45)",
  " (in 'string', line 34, column 2 to column 45)",
  " (in 'string', line 35, column 2 to column 37)",
  " (in 'string', line 37, column 15 to column 16)",
  " (in 'string', line 37, column 4 to column 55)",
  " (in 'string', line 38, column 4 to column 28)",
  " (in 'string', line 36, column 2 to line 39, column 3)",
  " (in 'string', line 2, column 2 to column 17)",
  " (in 'string', line 3, column 2 to column 17)",
  " (in 'string', line 4, column 9 to column 10)",
  " (in 'string', line 4, column 12 to column 13)",
  " (in 'string', line 4, column 2 to column 20)",
  " (in 'string', line 5, column 9 to column 10)",
  " (in 'string', line 5, column 2 to column 14)",
  " (in 'string', line 6, column 9 to column 10)",
  " (in 'string', line 6, column 2 to column 22)",
  " (in 'string', line 7, column 9 to column 10)",
  " (in 'string', line 7, column 2 to column 20)",
  " (in 'string', line 8, column 9 to column 14)",
  " (in 'string', line 8, column 2 to column 27)",
  " (in 'string', line 9, column 9 to column 14)",
  " (in 'string', line 9, column 2 to column 25)",
  " (in 'string', line 12, column 9 to column 10)",
  " (in 'string', line 12, column 2 to column 42)",
  " (in 'string', line 13, column 9 to column 10)",
  " (in 'string', line 13, column 2 to column 38)",
  " (in 'string', line 14, column 2 to column 36)",
  " (in 'string', line 15, column 2 to column 32)",
  " (in 'string', line 18, column 8 to column 9)",
  " (in 'string', line 20, column 9 to column 10)",
  " (in 'string', line 20, column 12 to column 13)",
  " (in 'string', line 23, column 9 to column 10)",
  " (in 'string', line 23, column 12 to column 13)",
  " (in 'string', line 25, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_rw1_model_naive final : public model_base_crtp<model_rw1_model_naive> {
private:
  int k;
  int n;
  Eigen::Matrix<double,-1,-1> xreg_data__;
  Eigen::Matrix<double,-1,1> y_data__;
  Eigen::Matrix<double,-1,1> beta_mean_data__;
  Eigen::Matrix<double,-1,1> beta_sd_data__;
  Eigen::Matrix<double,-1,1> sigma_mean_data__;
  Eigen::Matrix<double,-1,1> sigma_sd_data__;
  Eigen::Matrix<double,-1,1> sigma_b_mean_data__;
  Eigen::Matrix<double,-1,1> sigma_b_sd_data__;
  double sigma_y_mean;
  double sigma_y_sd;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> xreg{nullptr, 0, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> y{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> beta_mean{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> beta_sd{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> sigma_mean{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> sigma_sd{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> sigma_b_mean{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> sigma_b_sd{nullptr, 0};
public:
  ~model_rw1_model_naive() {}
  model_rw1_model_naive(stan::io::var_context& context__, unsigned int
                        random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_rw1_model_naive_namespace::model_rw1_model_naive";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 18;
      context__.validate_dims("data initialization", "k", "int",
        std::vector<size_t>{});
      k = std::numeric_limits<int>::min();
      current_statement__ = 18;
      k = context__.vals_i("k")[(1 - 1)];
      current_statement__ = 18;
      stan::math::check_greater_or_equal(function__, "k", k, 0);
      current_statement__ = 19;
      context__.validate_dims("data initialization", "n", "int",
        std::vector<size_t>{});
      n = std::numeric_limits<int>::min();
      current_statement__ = 19;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 19;
      stan::math::check_greater_or_equal(function__, "n", n, 0);
      current_statement__ = 20;
      stan::math::validate_non_negative_index("xreg", "k", k);
      current_statement__ = 21;
      stan::math::validate_non_negative_index("xreg", "n", n);
      current_statement__ = 22;
      context__.validate_dims("data initialization", "xreg", "double",
        std::vector<size_t>{static_cast<size_t>(k), static_cast<size_t>(n)});
      xreg_data__ = Eigen::Matrix<double,-1,-1>::Constant(k, n,
                      std::numeric_limits<double>::quiet_NaN());
      new (&xreg) Eigen::Map<Eigen::Matrix<double,-1,-1>>(xreg_data__.data(),
        k, n);
      {
        std::vector<local_scalar_t__> xreg_flat__;
        current_statement__ = 22;
        xreg_flat__ = context__.vals_r("xreg");
        current_statement__ = 22;
        pos__ = 1;
        current_statement__ = 22;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 22;
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            current_statement__ = 22;
            stan::model::assign(xreg, xreg_flat__[(pos__ - 1)],
              "assigning variable xreg", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 22;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 23;
      stan::math::validate_non_negative_index("y", "n", n);
      current_statement__ = 24;
      context__.validate_dims("data initialization", "y", "double",
        std::vector<size_t>{static_cast<size_t>(n)});
      y_data__ = Eigen::Matrix<double,-1,1>::Constant(n,
                   std::numeric_limits<double>::quiet_NaN());
      new (&y) Eigen::Map<Eigen::Matrix<double,-1,1>>(y_data__.data(), n);
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 24;
        y_flat__ = context__.vals_r("y");
        current_statement__ = 24;
        pos__ = 1;
        current_statement__ = 24;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 24;
          stan::model::assign(y, y_flat__[(pos__ - 1)],
            "assigning variable y", stan::model::index_uni(sym1__));
          current_statement__ = 24;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 25;
      stan::math::validate_non_negative_index("beta_mean", "k", k);
      current_statement__ = 26;
      context__.validate_dims("data initialization", "beta_mean", "double",
        std::vector<size_t>{static_cast<size_t>(k)});
      beta_mean_data__ = Eigen::Matrix<double,-1,1>::Constant(k,
                           std::numeric_limits<double>::quiet_NaN());
      new (&beta_mean)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(beta_mean_data__.data(), k);
      {
        std::vector<local_scalar_t__> beta_mean_flat__;
        current_statement__ = 26;
        beta_mean_flat__ = context__.vals_r("beta_mean");
        current_statement__ = 26;
        pos__ = 1;
        current_statement__ = 26;
        for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
          current_statement__ = 26;
          stan::model::assign(beta_mean, beta_mean_flat__[(pos__ - 1)],
            "assigning variable beta_mean", stan::model::index_uni(sym1__));
          current_statement__ = 26;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 27;
      stan::math::validate_non_negative_index("beta_sd", "k", k);
      current_statement__ = 28;
      context__.validate_dims("data initialization", "beta_sd", "double",
        std::vector<size_t>{static_cast<size_t>(k)});
      beta_sd_data__ = Eigen::Matrix<double,-1,1>::Constant(k,
                         std::numeric_limits<double>::quiet_NaN());
      new (&beta_sd)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(beta_sd_data__.data(), k);
      {
        std::vector<local_scalar_t__> beta_sd_flat__;
        current_statement__ = 28;
        beta_sd_flat__ = context__.vals_r("beta_sd");
        current_statement__ = 28;
        pos__ = 1;
        current_statement__ = 28;
        for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
          current_statement__ = 28;
          stan::model::assign(beta_sd, beta_sd_flat__[(pos__ - 1)],
            "assigning variable beta_sd", stan::model::index_uni(sym1__));
          current_statement__ = 28;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 29;
      stan::math::validate_non_negative_index("sigma_mean", "k + 1", (k + 1));
      current_statement__ = 30;
      context__.validate_dims("data initialization", "sigma_mean", "double",
        std::vector<size_t>{static_cast<size_t>((k + 1))});
      sigma_mean_data__ = Eigen::Matrix<double,-1,1>::Constant((k + 1),
                            std::numeric_limits<double>::quiet_NaN());
      new (&sigma_mean)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(sigma_mean_data__.data(), (k +
        1));
      {
        std::vector<local_scalar_t__> sigma_mean_flat__;
        current_statement__ = 30;
        sigma_mean_flat__ = context__.vals_r("sigma_mean");
        current_statement__ = 30;
        pos__ = 1;
        current_statement__ = 30;
        for (int sym1__ = 1; sym1__ <= (k + 1); ++sym1__) {
          current_statement__ = 30;
          stan::model::assign(sigma_mean, sigma_mean_flat__[(pos__ - 1)],
            "assigning variable sigma_mean", stan::model::index_uni(sym1__));
          current_statement__ = 30;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 31;
      stan::math::validate_non_negative_index("sigma_sd", "k + 1", (k + 1));
      current_statement__ = 32;
      context__.validate_dims("data initialization", "sigma_sd", "double",
        std::vector<size_t>{static_cast<size_t>((k + 1))});
      sigma_sd_data__ = Eigen::Matrix<double,-1,1>::Constant((k + 1),
                          std::numeric_limits<double>::quiet_NaN());
      new (&sigma_sd)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(sigma_sd_data__.data(), (k +
        1));
      {
        std::vector<local_scalar_t__> sigma_sd_flat__;
        current_statement__ = 32;
        sigma_sd_flat__ = context__.vals_r("sigma_sd");
        current_statement__ = 32;
        pos__ = 1;
        current_statement__ = 32;
        for (int sym1__ = 1; sym1__ <= (k + 1); ++sym1__) {
          current_statement__ = 32;
          stan::model::assign(sigma_sd, sigma_sd_flat__[(pos__ - 1)],
            "assigning variable sigma_sd", stan::model::index_uni(sym1__));
          current_statement__ = 32;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 33;
      stan::math::validate_non_negative_index("sigma_b_mean", "k", k);
      current_statement__ = 34;
      sigma_b_mean_data__ = Eigen::Matrix<double,-1,1>::Constant(k,
                              std::numeric_limits<double>::quiet_NaN());
      new (&sigma_b_mean)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(sigma_b_mean_data__.data(), k);
      current_statement__ = 34;
      stan::model::assign(sigma_b_mean,
        stan::model::rvalue(sigma_mean, "sigma_mean",
          stan::model::index_min(2)), "assigning variable sigma_b_mean");
      current_statement__ = 35;
      stan::math::validate_non_negative_index("sigma_b_sd", "k", k);
      current_statement__ = 36;
      sigma_b_sd_data__ = Eigen::Matrix<double,-1,1>::Constant(k,
                            std::numeric_limits<double>::quiet_NaN());
      new (&sigma_b_sd)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(sigma_b_sd_data__.data(), k);
      current_statement__ = 36;
      stan::model::assign(sigma_b_sd,
        stan::model::rvalue(sigma_sd, "sigma_sd", stan::model::index_min(2)),
        "assigning variable sigma_b_sd");
      current_statement__ = 37;
      sigma_y_mean = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 37;
      sigma_y_mean = stan::model::rvalue(sigma_mean, "sigma_mean",
                       stan::model::index_uni(1));
      current_statement__ = 38;
      sigma_y_sd = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 38;
      sigma_y_sd = stan::model::rvalue(sigma_sd, "sigma_sd",
                     stan::model::index_uni(1));
      current_statement__ = 39;
      stan::math::validate_non_negative_index("sigma_b", "k", k);
      current_statement__ = 40;
      stan::math::validate_non_negative_index("beta_raw", "k", k);
      current_statement__ = 41;
      stan::math::validate_non_negative_index("beta_raw", "n", n);
      current_statement__ = 42;
      stan::math::validate_non_negative_index("beta", "k", k);
      current_statement__ = 43;
      stan::math::validate_non_negative_index("beta", "n", n);
      current_statement__ = 44;
      stan::math::validate_non_negative_index("tmp", "k", k);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = k + 1 + (k * n);
  }
  inline std::string model_name() const final {
    return "model_rw1_model_naive";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_rw1_model_naive_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      std::vector<local_scalar_t__> sigma_b =
        std::vector<local_scalar_t__>(k, DUMMY_VAR__);
      current_statement__ = 1;
      sigma_b = in__.template read_constrain_lb<
                  std::vector<local_scalar_t__>, jacobian__>(0, lp__, k);
      local_scalar_t__ sigma_y = DUMMY_VAR__;
      current_statement__ = 2;
      sigma_y = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      Eigen::Matrix<local_scalar_t__,-1,-1> beta_raw =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(k, n, DUMMY_VAR__);
      current_statement__ = 3;
      beta_raw = in__.template read<Eigen::Matrix<local_scalar_t__,-1,-1>>(k,
                   n);
      Eigen::Matrix<local_scalar_t__,-1,-1> beta =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(k, n, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> tmp =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(k, DUMMY_VAR__);
      current_statement__ = 6;
      stan::model::assign(beta,
        stan::math::add(beta_mean,
          stan::math::elt_multiply(beta_sd,
            stan::model::rvalue(beta_raw, "beta_raw",
              stan::model::index_omni(), stan::model::index_uni(1)))),
        "assigning variable beta", stan::model::index_omni(),
        stan::model::index_uni(1));
      current_statement__ = 10;
      for (int t = 2; t <= n; ++t) {
        current_statement__ = 7;
        stan::model::assign(tmp,
          stan::model::rvalue(beta, "beta", stan::model::index_omni(),
            stan::model::index_uni((t - 1))), "assigning variable tmp");
        current_statement__ = 8;
        stan::model::assign(beta,
          stan::math::add(tmp,
            stan::math::elt_multiply(stan::math::to_vector(sigma_b),
              stan::model::rvalue(beta_raw, "beta_raw",
                stan::model::index_omni(), stan::model::index_uni(t)))),
          "assigning variable beta", stan::model::index_omni(),
          stan::model::index_uni(t));
      }
      {
        current_statement__ = 11;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(sigma_b,
                         sigma_b_mean, sigma_b_sd));
        current_statement__ = 12;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(sigma_y,
                         sigma_y_mean, sigma_y_sd));
        current_statement__ = 13;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(
                         stan::math::to_vector(beta_raw), 0, 1));
        {
          current_statement__ = 14;
          stan::math::validate_non_negative_index("mu", "n", n);
          Eigen::Matrix<local_scalar_t__,1,-1> mu =
            Eigen::Matrix<local_scalar_t__,1,-1>::Constant(n, DUMMY_VAR__);
          current_statement__ = 15;
          stan::model::assign(mu,
            stan::math::columns_dot_product(xreg, beta),
            "assigning variable mu");
          current_statement__ = 16;
          lp_accum__.add(stan::math::normal_lpdf<propto__>(y, mu, sigma_y));
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_rw1_model_naive_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      std::vector<double> sigma_b =
        std::vector<double>(k, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      sigma_b = in__.template read_constrain_lb<
                  std::vector<local_scalar_t__>, jacobian__>(0, lp__, k);
      double sigma_y = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      sigma_y = in__.template read_constrain_lb<local_scalar_t__,
                  jacobian__>(0, lp__);
      Eigen::Matrix<double,-1,-1> beta_raw =
        Eigen::Matrix<double,-1,-1>::Constant(k, n,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 3;
      beta_raw = in__.template read<Eigen::Matrix<local_scalar_t__,-1,-1>>(k,
                   n);
      Eigen::Matrix<double,-1,-1> beta =
        Eigen::Matrix<double,-1,-1>::Constant(k, n,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> tmp =
        Eigen::Matrix<double,-1,1>::Constant(k,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(sigma_b);
      out__.write(sigma_y);
      out__.write(beta_raw);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 6;
      stan::model::assign(beta,
        stan::math::add(beta_mean,
          stan::math::elt_multiply(beta_sd,
            stan::model::rvalue(beta_raw, "beta_raw",
              stan::model::index_omni(), stan::model::index_uni(1)))),
        "assigning variable beta", stan::model::index_omni(),
        stan::model::index_uni(1));
      current_statement__ = 10;
      for (int t = 2; t <= n; ++t) {
        current_statement__ = 7;
        stan::model::assign(tmp,
          stan::model::rvalue(beta, "beta", stan::model::index_omni(),
            stan::model::index_uni((t - 1))), "assigning variable tmp");
        current_statement__ = 8;
        stan::model::assign(beta,
          stan::math::add(tmp,
            stan::math::elt_multiply(stan::math::to_vector(sigma_b),
              stan::model::rvalue(beta_raw, "beta_raw",
                stan::model::index_omni(), stan::model::index_uni(t)))),
          "assigning variable beta", stan::model::index_omni(),
          stan::model::index_uni(t));
      }
      if (emit_transformed_parameters__) {
        out__.write(beta);
        out__.write(tmp);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      std::vector<local_scalar_t__> sigma_b =
        std::vector<local_scalar_t__>(k, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(sigma_b,
        in__.read<std::vector<local_scalar_t__>>(k),
        "assigning variable sigma_b");
      out__.write_free_lb(0, sigma_b);
      local_scalar_t__ sigma_y = DUMMY_VAR__;
      current_statement__ = 2;
      sigma_y = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, sigma_y);
      Eigen::Matrix<local_scalar_t__,-1,-1> beta_raw =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(k, n, DUMMY_VAR__);
      current_statement__ = 3;
      stan::model::assign(beta_raw,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,-1>>(k, n),
        "assigning variable beta_raw");
      out__.write(beta_raw);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "sigma_b",
        "double", std::vector<size_t>{static_cast<size_t>(k)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "sigma_y",
        "double", std::vector<size_t>{});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "beta_raw",
        "double",
        std::vector<size_t>{static_cast<size_t>(k), static_cast<size_t>(n)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      std::vector<local_scalar_t__> sigma_b =
        std::vector<local_scalar_t__>(k, DUMMY_VAR__);
      current_statement__ = 1;
      sigma_b = context__.vals_r("sigma_b");
      out__.write_free_lb(0, sigma_b);
      local_scalar_t__ sigma_y = DUMMY_VAR__;
      current_statement__ = 2;
      sigma_y = context__.vals_r("sigma_y")[(1 - 1)];
      out__.write_free_lb(0, sigma_y);
      Eigen::Matrix<local_scalar_t__,-1,-1> beta_raw =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(k, n, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> beta_raw_flat__;
        current_statement__ = 3;
        beta_raw_flat__ = context__.vals_r("beta_raw");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
            current_statement__ = 3;
            stan::model::assign(beta_raw, beta_raw_flat__[(pos__ - 1)],
              "assigning variable beta_raw", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 3;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write(beta_raw);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"sigma_b", "sigma_y", "beta_raw"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"beta", "tmp"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(k)},
                std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(k),
                  static_cast<size_t>(n)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(k),
               static_cast<size_t>(n)},
             std::vector<size_t>{static_cast<size_t>(k)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigma_b" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "sigma_y");
    for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
        param_names__.emplace_back(std::string() + "beta_raw" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
          param_names__.emplace_back(std::string() + "beta" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        param_names__.emplace_back(std::string() + "tmp" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {}
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
      param_names__.emplace_back(std::string() + "sigma_b" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "sigma_y");
    for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
        param_names__.emplace_back(std::string() + "beta_raw" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= k; ++sym2__) {
          param_names__.emplace_back(std::string() + "beta" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= k; ++sym1__) {
        param_names__.emplace_back(std::string() + "tmp" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {}
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"sigma_b\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(k) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_y\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(k) + ",\"cols\":" + std::to_string(n) + "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(k) + ",\"cols\":" + std::to_string(n) + "},\"block\":\"transformed_parameters\"},{\"name\":\"tmp\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(k) + "},\"block\":\"transformed_parameters\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"sigma_b\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(k) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_y\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(k) + ",\"cols\":" + std::to_string(n) + "},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(k) + ",\"cols\":" + std::to_string(n) + "},\"block\":\"transformed_parameters\"},{\"name\":\"tmp\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(k) + "},\"block\":\"transformed_parameters\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((k + 1) + (k * n));
    const size_t num_transformed = emit_transformed_parameters * (((k * n) +
      k));
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((k + 1) + (k * n));
    const size_t num_transformed = emit_transformed_parameters * (((k * n) +
      k));
    const size_t num_gen_quantities = emit_generated_quantities * (0);
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_rw1_model_naive_namespace::model_rw1_model_naive;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_rw1_model_naive_namespace::profiles__;
}
#endif
#endif
