% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webdeveloper.R
\name{dynamicTemplate}
\alias{dynamicTemplate}
\title{Replace placeholder variables in a HTML document string.}
\usage{
dynamicTemplate(x, replacements = c())
}
\arguments{
\item{x}{HTML string with placeholder variables that need to be replaced.}

\item{replacements}{A named vector or named list. Names should match a template variable acting as a placeholder in a HTML document string
and values should be the text to replace the placeholders with.}
}
\value{
A string of HTML with placeholder values replaced.
}
\description{
Replace placeholder variables in a HTML document string.
}
\examples{
dynamicTemplate(
x = html(body(templateVar("body_var"))),
replacements = c("\%\%rvar-body_var\%\%" = div(p("body replacement")))
)
}
