% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mab_impute.R
\name{impute_success}
\alias{impute_success}
\title{Imputing New Outcomes of Multi-Arm-Bandit Trial}
\usage{
impute_success(
  current_data,
  imputation_info,
  id_col,
  success_col,
  prior_data = NULL,
  perfect_assignment,
  dates = NULL,
  success_date_col,
  current_period = NULL
)
}
\arguments{
\item{current_data}{Updated tibble/data.frame object containing new treatments from \code{\link[=assign_treatments]{assign_treatments()}}.}

\item{imputation_info}{A tibble/data.frame containing conditional probability of success by treatment block, for each
combination that exists in \code{current_data}, calculated from the original experiment.
Passed to \code{\link[randomizr:block_ra]{randomizr::block_ra()}} to impute outcomes.}

\item{id_col}{Column in \code{data}; contains unique ID as a key.}

\item{success_col}{Column in \code{data}; binary successes from the original experiment.}

\item{prior_data}{A tibble/data.frame containing all the data from previous periods.
Used to join together at the end for the next iteration of the simulation.}

\item{perfect_assignment}{Logical; if TRUE, assumes perfect information for treatment assignment
(i.e., all outcomes are observed regardless of the date).
If FALSE, hides outcomes not yet theoretically observed, based
on the dates treatments would have been assigned for each wave.
This is useful when simulating batch-based assignment where treatments were assigned
on a given day whether or not all the information from a prior batch was available and
you have exact dates treatments were assigned.}

\item{dates}{Named date vector containing average success date by treatment block to impute new success dates for
observations whose change in treatment also changes their outcome from failure to success.}

\item{success_date_col}{Column in \code{data}; contains original dates each success occurred. Only necessary when \code{perfect_assignment = FALSE}. Must be of type \code{Date}, not a character string.}

\item{current_period}{Numeric value of length 1; current treatment wave of the simulation.}
}
\description{
Imputes outcomes for the current treatment assignment period.
Uses \code{\link[randomizr:block_ra]{randomizr::block_ra()}} to impute the outcomes for observations
who were assigned new treatments. The probabilities used to guide the imputation
of the outcomes are pre-computed using the existing data from the original randomized experiment.
}
\details{
When \code{perfect_assignment} is FALSE, dates of success are imputed according to the average
by each period and treatment block (treatment arm + any blocking). These imputations are required because
these observations do not currently have dates of success, as no success was observed during the original experiment.
Therefore if they go through the next iteration of the simulation without being imputed,
the new successes will still be treated as failues becasue of the date masking mechanism.

Observations that were successful in the original experiment, got assigned a new treatment, and then
imputed as success again, will have their original date kept. This assumes that the treatment has no individual
treatment effect on the date of success, which may or may not be valid depending on the context of the
experiment.
}
\seealso{
\itemize{
\item \code{\link[=imputation_preparation]{imputation_preparation()}}
\item \code{\link[=imputation_precompute]{imputation_precompute()}}
\item \code{\link[randomizr:block_ra]{randomizr::block_ra()}}
}
}
\keyword{internal}
