% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikiTools.R
\name{extractWiki}
\alias{extractWiki}
\title{Extract the first paragraph of a Wikipedia article with a maximum of characters.}
\usage{
extractWiki(
  names,
  language = c("en", "es", "fr", "de", "it"),
  plain = FALSE,
  maximum = 1000
)
}
\arguments{
\item{names}{A vector of names, whose entries have to be extracted.}

\item{language}{A vector of Wikipedia's languages to look for. If the article is not found in the language of the first element, it search for the followings,.}

\item{plain}{If TRUE, the results are delivered in plain format.}

\item{maximum}{Number maximum of characters to be included when the paragraph is too large.}
}
\value{
a character vector with html formatted (or plain text) Wikipedia paragraphs.
}
\description{
Extract the first paragraph of a Wikipedia article with a maximum of characters.
}
\examples{
\dontrun{
## Obtaining information in English Wikidata
names <- c("William Shakespeare", "Pedro Almodovar")
info <- getWikiInf(names)
info$text <- extractWiki(info$label)
}
}
\author{
Modesto Escobar, Department of Sociology and Communication, University of Salamanca. See \url{https://sociocav.usal.es/blog/modesto-escobar/}
}
