% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handle-crc.R, R/handle-rct.R, R/handle-sfc.R,
%   R/handle-wkb.R, R/handle-wkt.R, R/handle-xy.R, R/handler.R, R/pkg-sf.R
\name{wk_handle.wk_crc}
\alias{wk_handle.wk_crc}
\alias{wk_handle.wk_rct}
\alias{wk_handle.sfc}
\alias{wk_handle.wk_wkb}
\alias{wk_handle.wk_wkt}
\alias{wk_handle.wk_xy}
\alias{wk_handle}
\alias{is_handleable}
\alias{new_wk_handler}
\alias{is_wk_handler}
\alias{as_wk_handler}
\alias{wk_handle.sfg}
\alias{wk_handle.sf}
\alias{wk_handle.bbox}
\title{Read geometry vectors}
\usage{
\method{wk_handle}{wk_crc}(
  handleable,
  handler,
  ...,
  n_segments = getOption("wk.crc_n_segments", NULL),
  resolution = getOption("wk.crc_resolution", NULL)
)

\method{wk_handle}{wk_rct}(handleable, handler, ...)

\method{wk_handle}{sfc}(handleable, handler, ...)

\method{wk_handle}{wk_wkb}(handleable, handler, ...)

\method{wk_handle}{wk_wkt}(handleable, handler, ...)

\method{wk_handle}{wk_xy}(handleable, handler, ...)

wk_handle(handleable, handler, ...)

is_handleable(handleable)

new_wk_handler(handler_ptr, subclass = character())

is_wk_handler(handler)

as_wk_handler(handler, ...)

\method{wk_handle}{sfg}(handleable, handler, ...)

\method{wk_handle}{sf}(handleable, handler, ...)

\method{wk_handle}{bbox}(handleable, handler, ...)
}
\arguments{
\item{handleable}{A geometry vector (e.g., \code{\link[=wkb]{wkb()}}, \code{\link[=wkt]{wkt()}}, \code{\link[=xy]{xy()}},
\code{\link[=rct]{rct()}}, or \code{\link[sf:sfc]{sf::st_sfc()}}) for which \code{\link[=wk_handle]{wk_handle()}} is defined.}

\item{handler}{A \link[=wk_handle]{wk_handler} object.}

\item{...}{Passed to the \code{\link[=wk_handle]{wk_handle()}} method.}

\item{n_segments, resolution}{The number of segments to use when approximating
a circle. The default uses \code{getOption("wk.crc_n_segments")} so that
this value can be set for implicit conversions (e.g., \code{as_wkb()}).
Alternatively, set the minimum distance between points on the circle
(used to estimate \code{n_segments}). The default is obtained
using \code{getOption("wk.crc_resolution")}.}

\item{handler_ptr}{An external pointer to a newly created WK handler}

\item{subclass}{The handler subclass}
}
\value{
A WK handler.
}
\description{
The handler is the basic building block of the wk package. In
particular, the \code{\link[=wk_handle]{wk_handle()}} generic allows operations written
as handlers to "just work" with many different input types. The
wk package provides the \code{\link[=wk_void]{wk_void()}} handler, the \code{\link[=wk_format]{wk_format()}}
handler, the \code{\link[=wk_debug]{wk_debug()}} handler, the \code{\link[=wk_problems]{wk_problems()}} handler,
and \code{\link[=wk_writer]{wk_writer()}}s for \code{\link[=wkb]{wkb()}}, \code{\link[=wkt]{wkt()}}, \code{\link[=xy]{xy()}}, and \code{\link[sf:sfc]{sf::st_sfc()}})
vectors.
}
