% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_functions.R
\name{trapezoidal_integration}
\alias{trapezoidal_integration}
\title{Approximate the definite integral via the trapezoidal rule}
\usage{
trapezoidal_integration(x, f)
}
\arguments{
\item{x}{a variable, e.g. vector of positions}

\item{f}{integrand, e.g. vector of forces}
}
\value{
A numerical value indicating the value of the integral.
}
\description{
Mostly meant for internal use in our analysis functions, but made available
for other use cases. Accordingly, it does not strictly rely on objects of
class \code{muscle_stim}.
}
\details{
In the functions \code{analyze_workloop()}, \code{read_analyze_wl()}
, and \code{read_analyze_wl_dir()}, work is calculated as the difference
between the integral of the upper curve and the integral of the lower curve
of a work loop.
}
\examples{

# create a circle centered at (x = 10, y = 20) with radius 2
t <- seq(0, 2 * pi, length = 1000)
coords <- t(rbind(10 + sin(t) * 2, 20 + cos(t) * 2))


# use the function to get the area
trapezoidal_integration(coords[, 1], coords[, 2])

# does it match (pi * r^2)?
3.14159265358 * (2^2) # very close

}
\references{
Atkinson, Kendall E. (1989), An Introduction to Numerical
Analysis (2nd ed.), New York: John Wiley & Sons
}
\seealso{
\code{\link{analyze_workloop}},
\code{\link{read_analyze_wl}},
\code{\link{read_analyze_wl_dir}}
}
\author{
Vikram B. Baliga
}
