% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get1stOfRepeatedByCol.R
\name{get1stOfRepeatedByCol}
\alias{get1stOfRepeatedByCol}
\title{Get first of repeated by column}
\usage{
get1stOfRepeatedByCol(
  mat,
  sortBy = "seq",
  sortSupl = "ty",
  asFirstLast = c("full", "inter"),
  markIfAmbig = c("ambig", "seqNa"),
  asList = FALSE,
  abmiPref = "_",
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{mat}{(matrix or data.frame) numeric vector to be tested}

\item{sortBy}{(character) column name for which elements should be made unique, numeric or character column; 'sortSupl' .. add'l colname to always select specific 1st)}

\item{sortSupl}{(character) default="ty"}

\item{asFirstLast}{(character,length=2) to force specific strings from coluln 'sortSupl' as first and last when selecting 1st of repeated terms, default=c("full","inter")}

\item{markIfAmbig}{(character,length=2) 1st will be set to 'TRUE' if ambiguous/repeated, 2nd will get (heading) prefix, default=c("ambig","seqNa")}

\item{asList}{(logical) to return list with non-redundant ('unique') and removed lines ('repeats')}

\item{abmiPref}{(character) prefix to note ambiguous entries/terms, default="_"}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns depending on argumnet 'asList' either list with non-redundant ('unique') and removed lines ('repeats')
}
\description{
\code{get1stOfRepeatedByCol} sorts matrix 'mat' and extracts only 1st occurance of values in column 'sortBy'.
Returns then non-redundant matrix (ie for column 'sortBy', if 'markIfAmbig' specifies existing col, mark ambig there).
Note : problem when sortSupl or sortBy not present (or not intended for use)
}
\examples{
aa <- cbind(no=as.character(1:20),seq=sample(LETTERS[1:15],20,repl=TRUE),
  ty=sample(c("full","Nter","inter"),20,repl=TRUE),ambig=rep(NA,20),seqNa=1:20)
get1stOfRepeatedByCol(aa)
}
\seealso{
\code{\link{firstOfRepeated}} for (more basic) treatment of simple vector, \code{\link{nonAmbiguousNum}} for numeric use (much faster !!!)
}
