% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreChargeCatch.R
\name{scoreChargeCatch}
\alias{scoreChargeCatch}
\title{Scoring Of Charge Catching Potential For Peptides}
\usage{
scoreChargeCatch(
  resTab,
  pepCol = "seq",
  scale01 = TRUE,
  chargeMode = "pos",
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{resTab}{(matrix or data.frame) matrix or data.frame of results for SINGLE protein (here only the column specified with argument 'pepCol' will be used)}

\item{pepCol}{(character) column name of 'resTab' containing the peptide sequence to be scored}

\item{scale01}{(logical) linear rescale output to maximum 1.0}

\item{chargeMode}{(character) this value may be 'pos' (default) for the positively charged amino-acids K,R and H or, 
if this argument has any other value, than all charged amino-acids (K,R,H, S,T,N,Q, D,E, W and Y) will be considered.}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages and objects exportet to current session for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a numeric vector with score for each peptide of resTab (even if \code{scale01=TRUE} minimum may be >0 if all peptides do contain charge-catching AAs)
}
\description{
Make score based on cumulative search for AA with given potential to catch charge (H+, or optionally any charge).
Note : at current cumulative scoring large peptides may get priviliged.
}
\examples{
resTa <- matrix(c(1:4, "PEPTID","PEPTIK","PEPTRK","AGV"), ncol=2,
  dimnames=list(NULL,c("predInd","seq"))) 
scoreChargeCatch(resTa)

}
\seealso{
\code{\link{fragmentSeq}}
}
