% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc.R
\name{bc}
\alias{bc}
\title{Blank Concatenate. Parse argument as a vector of values allowing "blank separators".}
\usage{
bc(s, ..., sep_symbols = ",|", strict = TRUE, convert = TRUE)
}
\arguments{
\item{s}{string to parse}

\item{...}{force later arguments to be set by name}

\item{sep_symbols}{characters to consider separators}

\item{strict}{logical, if TRUE throw exception on confusing input}

\item{convert}{logical, if TRUE try to convert from string type to other types}
}
\value{
vector of values
}
\description{
Separates string data on whitespace and separating symbols into an array.
}
\details{
Can throw exception on lack of explicit value separators, example: \code{bc('"a""b"')} and  non-matching portions.
Whitespace is normalized to spaces. Attempts to split on obvious number format boundaries.
Suggested by Emil Erik Pula Bellamy Begtrup-Bright \url{https://github.com/WinVector/wrapr/issues/12}.
}
\examples{

bc('1 2 "c", d') # returns c("1", "2", "c", "d")
bc('1 2 3') # returns c(1, 2, 3)
bc('1 2 "3"') # returns c("1", "2", "3")
bc('1,2|3.4') # returns c(1, 2, 3.4)
bc('01 02', convert=FALSE) # returns c("01", "02")

}
\seealso{
\code{\link{qc}}, \code{\link{qe}}, \code{\link{qae}}, \code{\link[base]{bquote}}, \code{\link{sx}}
}
