% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grnn.x_pfi.R
\name{grnn.x_pfi}
\alias{grnn.x_pfi}
\title{Derive the permutation feature importance of a predictor used in the GRNN}
\usage{
grnn.x_pfi(net, i, class = FALSE, ntry = 1000, seed = 1)
}
\arguments{
\item{net}{The GRNN object generated by grnn.fit()}

\item{i}{The ith predictor in the GRNN}

\item{class}{TRUE or FALSE, whether it is for the classification or not}

\item{ntry}{The number of random permutations to try, 1e3 times by default}

\item{seed}{The seed value for the random permutation}
}
\value{
A vector with the variable name and the PFI value.
}
\description{
The function \code{grnn.x_pfi} derives the permutation feature importance (PFI) of a predictor used in the GRNN
}
\examples{
data(iris, package = "datasets")
Y <- ifelse(iris[, 5] == "setosa", 1, 0)
X <- scale(iris[, 1:4])
gnet <- grnn.fit(x = X, y = Y)
grnn.x_pfi(net = gnet, 1)
}
\seealso{
\code{\link{grnn.x_imp}}
}
