% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num-mpe.R
\name{mpe}
\alias{mpe}
\alias{mpe.data.frame}
\alias{mpe_vec}
\title{Mean percentage error}
\usage{
mpe(data, ...)

\method{mpe}{data.frame}(data, truth, estimate, na_rm = TRUE, case_weights = NULL, ...)

mpe_vec(truth, estimate, na_rm = TRUE, case_weights = NULL, ...)
}
\arguments{
\item{data}{A \code{data.frame} containing the columns specified by the \code{truth}
and \code{estimate} arguments.}

\item{...}{Not currently used.}

\item{truth}{The column identifier for the true results
(that is \code{numeric}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, a \code{numeric} vector.}

\item{estimate}{The column identifier for the predicted
results (that is also \code{numeric}). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name. For \verb{_vec()} functions, a \code{numeric} vector.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{case_weights}{The optional column identifier for case weights. This
should be an unquoted column name that evaluates to a numeric column in
\code{data}. For \verb{_vec()} functions, a numeric vector,
\code{\link[hardhat:importance_weights]{hardhat::importance_weights()}}, or \code{\link[hardhat:frequency_weights]{hardhat::frequency_weights()}}.}
}
\value{
A \code{tibble} with columns \code{.metric}, \code{.estimator},
and \code{.estimate} and 1 row of values.

For grouped data frames, the number of rows returned will be the same as
the number of groups.

For \code{mpe_vec()}, a single \code{numeric} value (or \code{NA}).
}
\description{
Calculate the mean percentage error. This metric is in \emph{relative
units}. It can be used as a measure of the \code{estimate}'s bias.

Note that if \emph{any} \code{truth} values are \code{0}, a value of:
\code{-Inf} (\code{estimate > 0}), \code{Inf} (\code{estimate < 0}), or \code{NaN} (\code{estimate == 0})
is returned for \code{mpe()}.
}
\examples{
# `solubility_test$solubility` has zero values with corresponding
# `$prediction` values that are negative. By definition, this causes `Inf`
# to be returned from `mpe()`.
solubility_test[solubility_test$solubility == 0, ]

mpe(solubility_test, solubility, prediction)

# We'll remove the zero values for demonstration
solubility_test <- solubility_test[solubility_test$solubility != 0, ]

# Supply truth and predictions as bare column names
mpe(solubility_test, solubility, prediction)

library(dplyr)

set.seed(1234)
size <- 100
times <- 10

# create 10 resamples
solubility_resampled <- bind_rows(
  replicate(
    n = times,
    expr = sample_n(solubility_test, size, replace = TRUE),
    simplify = FALSE
  ),
  .id = "resample"
)

# Compute the metric by group
metric_results <- solubility_resampled \%>\%
  group_by(resample) \%>\%
  mpe(solubility, prediction)

metric_results

# Resampled mean estimate
metric_results \%>\%
  summarise(avg_estimate = mean(.estimate))
}
\seealso{
Other numeric metrics: 
\code{\link{ccc}()},
\code{\link{huber_loss}()},
\code{\link{huber_loss_pseudo}()},
\code{\link{iic}()},
\code{\link{mae}()},
\code{\link{mape}()},
\code{\link{mase}()},
\code{\link{msd}()},
\code{\link{poisson_log_loss}()},
\code{\link{rmse}()},
\code{\link{rpd}()},
\code{\link{rpiq}()},
\code{\link{rsq}()},
\code{\link{rsq_trad}()},
\code{\link{smape}()}

Other accuracy metrics: 
\code{\link{ccc}()},
\code{\link{huber_loss}()},
\code{\link{huber_loss_pseudo}()},
\code{\link{iic}()},
\code{\link{mae}()},
\code{\link{mape}()},
\code{\link{mase}()},
\code{\link{msd}()},
\code{\link{poisson_log_loss}()},
\code{\link{rmse}()},
\code{\link{smape}()}
}
\author{
Thomas Bierhance
}
\concept{accuracy metrics}
\concept{numeric metrics}
