

//! ## Atomics




//! ## Thread synchronization





//! ## Utilities












#![no_std]
#![doc(test(
    no_crate_inject,
    attr(
        deny(warnings, rust_2018_idioms),
        allow(dead_code, unused_assignments, unused_variables)
    )
))]
#![warn(
    missing_docs,
    missing_debug_implementations,
    rust_2018_idioms,
    unreachable_pub
)]

#[cfg(feature = "std")]
extern crate std;

#[cfg(crossbeam_loom)]
#[allow(unused_imports)]
mod primitive {
    pub(crate) mod hint {
        pub(crate) use loom::hint::spin_loop;
    }
    pub(crate) mod sync {
        pub(crate) mod atomic {
            pub(crate) use loom::sync::atomic::{
                AtomicBool, AtomicI16, AtomicI32, AtomicI64, AtomicI8, AtomicIsize, AtomicU16,
                AtomicU32, AtomicU64, AtomicU8, AtomicUsize, Ordering,
            };

            
            
            
            
            
            pub(crate) use loom::sync::atomic::fence as compiler_fence;
        }
        pub(crate) use loom::sync::{Arc, Condvar, Mutex};
    }
}
#[cfg(not(crossbeam_loom))]
#[allow(unused_imports)]
mod primitive {
    pub(crate) mod hint {
        pub(crate) use core::hint::spin_loop;
    }
    pub(crate) mod sync {
        pub(crate) mod atomic {
            pub(crate) use core::sync::atomic::{compiler_fence, Ordering};
            #[cfg(not(crossbeam_no_atomic))]
            pub(crate) use core::sync::atomic::{
                AtomicBool, AtomicI16, AtomicI8, AtomicIsize, AtomicU16, AtomicU8, AtomicUsize,
            };
            #[cfg(not(crossbeam_no_atomic))]
            #[cfg(any(target_has_atomic = "32", not(target_pointer_width = "16")))]
            pub(crate) use core::sync::atomic::{AtomicI32, AtomicU32};
            #[cfg(not(crossbeam_no_atomic))]
            #[cfg(any(
                target_has_atomic = "64",
                not(any(target_pointer_width = "16", target_pointer_width = "32")),
            ))]
            pub(crate) use core::sync::atomic::{AtomicI64, AtomicU64};
        }

        #[cfg(feature = "std")]
        pub(crate) use std::sync::{Arc, Condvar, Mutex};
    }
}

pub mod atomic;

mod cache_padded;
pub use crate::cache_padded::CachePadded;

mod backoff;
pub use crate::backoff::Backoff;

#[cfg(feature = "std")]
pub mod sync;

#[cfg(feature = "std")]
#[cfg(not(crossbeam_loom))]
pub mod thread;
