#***********************************************************************************************************************************************
#*  
#*  (C) 2009     Andrzej Bk     Uniwersytet Ekonomiczny we Wrocawiu
#*  
#*  Funkcja do ksiki:
#*  "Statystyczna analiza danych z wykorzystaniem programu R", PWN, Warszawa 2009.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

# MaxUtility(Usym, S, r) - funkcja obliczajca udziay w rynku profilw symulacyjnych na podstawie modelu maksymalnej uytecznoci
# Usym - macierz uytecznoci cakowitych profilw symulacyjnych w przekroju respondentw
# S - liczba respondentw
# r - liczba profilw symulacyjnych
# wywoanie - Pmu <- MaxUtility(Usym, S, r)

MaxUtility <- function(Usym, S, r)
{
   count <- vector("numeric", r)   #wektor czstoci
   for(s in 1:S) {count[which.max(Usym[,s])] <- count[which.max(Usym[,s])]+1}
   Pmu <- (count/sum(count))*100
   return(Pmu)
}