#***********************************************************************************************************************************************
#*  
#*  (C) 2009     Andrzej Bk     Uniwersytet Ekonomiczny we Wrocawiu
#*  
#*  Funkcja do ksiki:
#*  "Statystyczna analiza danych z wykorzystaniem programu R", PWN, Warszawa 2009.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

# matexpand(m, n, S, x) - funkcja rozwija macierz ukadu czynnikowego na zbir respondentw
# w celu estymacji modelu na poziomie zagregowanym
# m - liczba atrybutw
# n - liczba profilw
# S - liczba respondentw
# x - macierz atrybutw (profile)
# wywoanie - x <- as.data.frame(matexpand(m, n, S, x))

matexpand <- function(m, n, S, x)
{
   N <- n*S               #liczba obserwacji
   X <- matrix(0, N, m)   #rozwinita macierz ukadu czynnikowego
   k <- 1
   for(s in 1:S)
   {
      for(i in 1:n)
      {
         for(j in 1:m) {X[k,j] <- x[i,j]}
         k <- k+1
      }
   }
   colnames(X) <- names(x)   #nazwy atrybutw
   return(X)
}