#***********************************************************************************************************************************************
#*  
#*  (C) 2011     Micha Trzsiok     Uniwersytet Ekonomiczny w Katowicach
#*  
#*  Skrypt do ksiki:
#*  "Analiza danych jakociowych i symbolicznych z wykorzystaniem programu R", C.H. Beck, Warszawa 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************
 
options(OutDec=",")
library(car) #zawiera zbir danych Chile
library(MASS)
data(Chile)
dane<-Chile[,c('sex','education','vote','age')] #do analizy wybierane s tylko 4 zmienne
dane<-dane[!apply(is.na(dane),1,any),] #usunicie obserwacji z brakami danych
dane$age<-cut(dane$age,fivenum(dane$age)) #dyskretyzacja zmiennej 'wiek' z wykorzystaniem kwartyli
attach(dane)
print("Do przeprowadzenia analizy wykorzystane zostan dane zapisane w postaci wielowymiarowej tablicy kontyngencji.",quote=FALSE)
tablica.kontyngencji<-xtabs(~sex+education+vote+age)
print("Zbudowana zostanie sekwencja modeli, zaczynajc od najprostszych, nie uwzgldniajcych interakcji, rozbudowujc je nastpnie o interakcje pomidzy wszystkimi parami i trjkami zmiennych.",quote=FALSE)
model.bez.interakcji<-loglm(~sex+education+vote+age,data=tablica.kontyngencji)
print("Charakterystyki modelu bez uwzgldnienia interakcji:",quote=FALSE)
print(model.bez.interakcji)
model.interakcje2<-update(model.bez.interakcji, ~.^2, data=tablica.kontyngencji)
print("Charakterystyki modelu z interakcjami midzy wszystkimi parami zmiennych:",quote=FALSE)
print(model.interakcje2)
model.interakcje3 <-update(model.bez.interakcji, ~.^3, data=tablica.kontyngencji)
print("Charakterystyki modelu z interakcjami midzy wszystkimi trjkami zmiennych:",quote=FALSE)
print(model.interakcje3)