################PRELIMINARES
#Nos situamos en el directorio de trabajo
setwd("D:/Asignaturas/Curso R")
#Si queremos saber en qu directorio estamos
getwd()

###############INTRODUCIR CONJUNTOS DE DATOS EN R
#Definimos vectores de datos
x<-c(161,203,235,176,201,188,228,211,191,178)
y<-c(159,206,241,163,197,193,209,189,169,201) 
genero<-factor(c("Hombre","Mujer","Hombre","Hombre","Hombre","Mujer","Mujer","Mujer","Hombre","Hombre"))

#Definimos una hoja de datos
Datos.Pruebas<-data.frame(Prueba.escrita=x,Prueba.oral=y,Genero=genero) 
Datos.Pruebas#Para verlos todos
Datos.Pruebas$Genero#Para acceder a la variable Genero, por ejemplo

#Definimos un vector de datos a partir de una distribucin de frecuencias
muertes<-c(rep(0,109),rep(1,65),rep(2,22),rep(3,3),4)
Datos.muertes<-data.frame(muertes)#Ahora mismo cambio el nombre de la variable
names(Datos.muertes)<-c("Muertes")
Datos.muertes

#Cmo puedo saber qu objetos tengo ahora mismo en la sesin de trabajo?
objects()


################GUARDAR CONJUNTOS DE DATOS EN R
#Vamos a guardar cada conjunto de datos en un fichero de datos de R
save(Datos.muertes,file="DatosMuertesCoces.rda")
save(Datos.Pruebas,file="DatosPruebas.RData")
#Estarn ah?
dir(pattern="rda")#El de las muertes s est
dir(pattern="RData")#El de las pruebas tambin


##################IMPORTAR CONJUNTOS DE DATOS EN R

#Importar archivos de texto
#En este ejemplo:
#Los nombres de las variables estn en el fichero. Por eso header=TRUE
#Las variable estn separadas por tabulaciones, por lo que sep="\t"
#Los decimales estn detrs de una coma, por lo que dec=","
Datos.contaminante<-read.table("Importa_texto.txt",header=TRUE,sep="\t",dec=",")
names(Datos.contaminante)
Datos.contaminante$Rural#Anda! Falta al final un dato, porque slo hay 14 datos de mbito rural

#Otro ejemplo de datos
#Variables separadas por espacios. Como es la opcin por defecto, no hace falta especificarlo)
#Con nombres de variables en la cabecera. Por eso header=TRUE
#Y decimales separados por puntos. Como es la opcin por defecto, no hace falta especificarlo
Datos.muelle<-read.table("Hook.txt",header=TRUE)
names(Datos.muelle)
Datos.muelle

#Importar datos desde archivos de Excel
library(RODBC)
conexion<-odbcConnectExcel("JaenUsosSuelo.xls")
Datos.usos.suelo<-sqlQuery(channel=conexion,"select * from [Hoja1$]")
close(conexion) 
names(Datos.usos.suelo)

##################CREAR NUEVAS VARIABLES CON R
names(Datos.usos.suelo)
#Calculamos la extensin total del municipio sumando todas las variables que determinan su extensin
Datos.usos.suelo$Extension.total<-Datos.usos.suelo$"Barbecho y otras tierras"+Datos.usos.suelo$"Cultivos herbceos"+Datos.usos.suelo$"Cultivos leosos"+Datos.usos.suelo$"Prados naturales"+Datos.usos.suelo$"Pastizales"+Datos.usos.suelo$"Monte maderable"+Datos.usos.suelo$"Monte abierto"+Datos.usos.suelo$"Monte leoso"+Datos.usos.suelo$"Erial a pastos"+Datos.usos.suelo$"Espartizales"+Datos.usos.suelo$"Terreno improductivo"+Datos.usos.suelo$"Superficie no agrcola"+Datos.usos.suelo$"Ros y lagos" 
#Qu pesado de escribir! Seamos eficientes: slo tenemos que sumar, por filas, de la variable 2 a la ltima
Datos.usos.suelo$Extension.total<-rowSums(Datos.usos.suelo[,2:14])

#Ahora sumamos slo las variables que determinan la extensin de monte, lo dividimos entre la extensin total y lo multiplicamos por 100 para expresarlo en porcentaje
Datos$prop.monte<-100*(Datos$"Monte maderable"+Datos$"Monte abierto"+Datos$"Monte leoso")/Datos$Extension.total  
#O bien
Datos.usos.suelo$prop.monte<-100*(rowSums(Datos.usos.suelo[,7:9]))/Datos.usos.suelo$Extension.total
#Comproblemos que estn
Datos.usos.suelo


###############RECODIFICAR VARIABLES EN R
#Cargamos los datos
library(RODBC)
conexion <- odbcConnectExcel("JaenCordoba.xls")
Datos.jaen.cordoba <- sqlQuery(channel = conexion, "select * from [Hoja1$]")
close(conexion)
names(Datos.jaen.cordoba)
Datos.jaen.cordoba$ine
#Recodificamos el cdigo ine para identificar quines son de Crdoba y quines de Jan
library(car)
Datos.jaen.cordoba$Provincia<-recode(Datos.jaen.cordoba$ine,"14000:14999='Crdoba';	23000:23999='Jan'",as.factor.result=TRUE)
Datos.jaen.cordoba$Provincia


###############FILTRAR VARIABLES EN R
#Slo queremos quedarnos con los municipios de Jan, y con todas las variables
Datos.jaen<-Datos.jaen.cordoba[Datos.jaen.cordoba$Provincia=="Jan",]
Datos.jaen$Nombre