#*****************************************************************************************************************************************************
#*  
#*  (C) 2011     Marek Walesiak     Uniwersytet Ekonomiczny we Wrocawiu
#*
#*  Skrypt do ksiki:
#*  Walesiak M., Uoglniona miara odlegoci GDM w statystycznej analizie wielowymiarowej z wykorzystaniem programu R, Wydawnictwo UE, Wrocaw 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#*****************************************************************************************************************************************************

library(clusterSim)
x1<-read.csv2("Warunki_mieszkaniowe_1999.csv",header=TRUE,row.names=1)
x2<-read.csv2("Warunki_mieszkaniowe_2008.csv",header=TRUE,row.names=1)
x<-rbind(x1,x2)
options(OutDec=",")
res<-pattern.GDM1(x,performanceVariable=c("s","s","s","s","s","s","d","d","s","s"),
   scaleType="r",nomOptValues=NULL,weightsType="equal",normalization="n1",patternType="upper",
   patternCoordinates="manual",patternManual=c(100,100,100,100,100,"max","min","min","max","max"),
   nominalTransfMethod=NULL)
res_GDM<-as.matrix(res$distances)
res1<-res_GDM[1:nrow(x1),]
res2<-res_GDM[(nrow(x1)+1):nrow(x),]
print("Obliczenia czstkowe dla miernika Theila",quote=FALSE)
print("rednie z wartoci zmiennej syntetycznej dla okresu t oraz q",quote=FALSE)
print(mean(res1))
print(mean(res2))
print("Odchylenia standardowe z wartoci zmiennej syntetycznej dla okresu t oraz q",quote=FALSE)
sd1<-sqrt((1/nrow(x1))*sum((res1-mean(res1))^2))
sd2<-sqrt((1/nrow(x1))*sum((res2-mean(res2))^2))
print(sd1)
print(sd2)
print("Wspczynnik korelacji Pearsona midzy wartoci zmiennej syntetycznej dla okresu t oraz q",quote=FALSE)
print(cor(res1,res2))
print("Warto miernika W Theila",quote=FALSE)
Theil_W<-print(sqrt((1/nrow(x1))*(sum((res2-res1)^2))))
print("Warto miernika W kwadrat Theila",quote=FALSE)
Theil_W_kwadrat<-print((1/nrow(x1))*(sum((res2-res1)^2)))
print("Warto miernika czstkowego W1 kwadrat Theila",quote=FALSE)
Theil_W1_kwadrat<-print((mean(res2)-mean(res1))^2)
print("Warto miernika czstkowego W2 kwadrat Theila",quote=FALSE)
Theil_W2_kwadrat<-print((sd2-sd1)^2)
print("Warto miernika czstkowego W3 kwadrat Theila",quote=FALSE)
Theil_W3_kwadrat<-print(2*sd2*sd1*(1-cor(res1,res2)))
