% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh_aseba.R
\name{compute_mh_p_abcl__synd__ext_tscore}
\alias{compute_mh_p_abcl__synd__ext_tscore}
\title{Compute "Adult Behavior Checklist [Parent] (Syndrome Scale - External):
T-score"}
\usage{
compute_mh_p_abcl__synd__ext_tscore(
  data,
  data_norm = NULL,
  name = "mh_p_abcl__synd__ext_tscore",
  col_age = "mh_p_abcl__cg2__age_001",
  col_sex = "mh_p_abcl__cg2_sex",
  max_na = 2,
  exclude = c("777", "999"),
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{data_norm}{tbl. Data frame containing the norm (T-score) values.
see \code{\link[=ss_tscore]{ss_tscore()}}.}

\item{name}{character. Name of the summary score column.}

\item{col_age}{character, name of the age column. see \code{\link[=ss_tscore]{ss_tscore()}}.}

\item{col_sex}{character, name of the sex column. see \code{\link[=ss_tscore]{ss_tscore()}}.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed. \code{NULL} means no limit.}

\item{exclude}{character vector. Values to be excluded from the summary score.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_p_abcl__synd__ext_tscore}
Adult Behavior Checklist [Parent] (Syndrome Scale - External): T-score
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_p_abcl__aggr_001}
\item \code{mh_p_abcl__aggr_002}
\item \code{mh_p_abcl__aggr_003}
\item \code{mh_p_abcl__aggr_004}
\item \code{mh_p_abcl__aggr_005}
\item \code{mh_p_abcl__aggr_006}
\item \code{mh_p_abcl__aggr_007}
\item \code{mh_p_abcl__aggr__adhd_001}
\item \code{mh_p_abcl__aggr__antsoc_001}
\item \code{mh_p_abcl__aggr__antsoc_002}
\item \code{mh_p_abcl__aggr__antsoc_003}
\item \code{mh_p_abcl__aggr__antsoc_004}
\item \code{mh_p_abcl__aggr__antsoc_005}
\item \code{mh_p_abcl__aggr__antsoc_006}
\item \code{mh_p_abcl__aggr__antsoc_007}
\item \code{mh_p_abcl__aggr__antsoc_008}
\item \code{mh_p_abcl__rule_001}
\item \code{mh_p_abcl__rule_002}
\item \code{mh_p_abcl__rule_003}
\item \code{mh_p_abcl__rule__adhd_001}
\item \code{mh_p_abcl__rule__antsoc_001}
\item \code{mh_p_abcl__rule__antsoc_002}
\item \code{mh_p_abcl__rule__antsoc_003}
\item \code{mh_p_abcl__rule__antsoc_004}
\item \code{mh_p_abcl__rule__antsoc_005}
\item \code{mh_p_abcl__rule__antsoc_006}
\item \code{mh_p_abcl__rule__antsoc_007}
\item \code{mh_p_abcl__rule__antsoc_008}
\item \code{mh_p_abcl__rule__antsoc_009}
\item \code{mh_p_abcl__intru_001}
\item \code{mh_p_abcl__intru_002}
\item \code{mh_p_abcl__intru_003}
\item \code{mh_p_abcl__intru_004}
\item \code{mh_p_abcl__intru_005}
\item \code{mh_p_abcl__intru_006}
}
\item \emph{Excluded values:}
\itemize{
\item 777
\item 999
}
\item \emph{Validation criterion:} maximally 2 of 35 items missing
}
}
\examples{
\dontrun{
compute_mh_p_abcl__synd__ext_tscore(data) |>
  select(
    any_of(c("mh_p_abcl__synd__ext_tscore", vars_mh_p_abcl__synd__ext))
  )
}
}
\seealso{
\code{\link[=compute_mh_p_abcl__synd__ext_nm]{compute_mh_p_abcl__synd__ext_nm()}}
}
