% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh_aseba.R
\name{compute_mh_y_bpm_tscore}
\alias{compute_mh_y_bpm_tscore}
\title{Compute "Brief Problem Monitor [Youth]: T-score"}
\usage{
compute_mh_y_bpm_tscore(
  data,
  data_norm = NULL,
  name = "mh_y_bpm_tscore",
  col_age = "mh_y_bpm_age",
  col_sex = "ab_g_stc__cohort_sex",
  max_na = 1,
  exclude = c("777", "999"),
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{data_norm}{tbl. Data frame containing the norm (T-score) values.
see \code{\link[=ss_tscore]{ss_tscore()}}.}

\item{name}{character. Name of the summary score column.}

\item{col_age}{character, name of the age column. see \code{\link[=ss_tscore]{ss_tscore()}}.}

\item{col_sex}{character, name of the sex column. see \code{\link[=ss_tscore]{ss_tscore()}}.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed. \code{NULL} means no limit.}

\item{exclude}{character vector. Values to be excluded from the summary score.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_y_bpm_tscore}
Brief Problem Monitor [Youth]: T-score
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_y_bpm__attn_001}
\item \code{mh_y_bpm__attn_002}
\item \code{mh_y_bpm__attn_003}
\item \code{mh_y_bpm__attn_004}
\item \code{mh_y_bpm__attn_005}
\item \code{mh_y_bpm__attn_006}
\item \code{mh_y_bpm__ext_001}
\item \code{mh_y_bpm__ext_002}
\item \code{mh_y_bpm__ext_003}
\item \code{mh_y_bpm__ext_004}
\item \code{mh_y_bpm__ext_005}
\item \code{mh_y_bpm__ext_006}
\item \code{mh_y_bpm__ext_007}
\item \code{mh_y_bpm__int_001}
\item \code{mh_y_bpm__int_002}
\item \code{mh_y_bpm__int_003}
\item \code{mh_y_bpm__int_004}
\item \code{mh_y_bpm__int_005}
\item \code{mh_y_bpm__int_006}
}
\item \emph{Excluded values:}
\itemize{
\item 777
\item 999
}
\item \emph{Validation criterion:} maximally 1 of 19 items missing
}
}
\examples{
\dontrun{
compute_mh_y_bpm_tscore(data) |>
  select(
    any_of(c("mh_y_bpm_tscore", vars_mh_y_bpm))
  )
}
}
\seealso{
\code{\link[=compute_mh_y_bpm_nm]{compute_mh_y_bpm_nm()}}
}
