% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_nc.R
\docType{data}
\name{vars_nc_p_bdefs}
\alias{vars_nc_p_bdefs}
\alias{compute_nc_p_bdefs_sum}
\title{Compute "Barkley Deficits in Executive Functioning Scale [Parent] (EF
Summary Score): Sum"}
\format{
vars_nc_p_bdefs is a character vector of all column names
used to compute summary scores of \code{nc_p_bdefs}.
}
\usage{
vars_nc_p_bdefs

compute_nc_p_bdefs_sum(
  data,
  name = "nc_p_bdefs_sum",
  max_na = 0,
  combine = TRUE
)
}
\arguments{
\item{data}{tbl, Dataframe containing the columns to be summarized.}

\item{name}{character, Name of the new column to be created. Default is
the name in description, but users can change it.}

\item{max_na}{integer, Maximum number of missing values allowed in the
summary score. \code{NULL} means no limit.}

\item{combine}{logical, If \code{TRUE}, the summary score will be appended to
the input data frame. If \code{FALSE}, the summary score will be returned as a
separate data frame.}
}
\value{
tbl. The input data frame with the summary score appended as
a new column.
}
\description{
Computes the summary score \code{nc_p_bdefs_sum}
Barkley Deficits in Executive Functioning Scale [Parent] (EF Summary
Score): Sum
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{nc_p_bdefs_001}
\item \code{nc_p_bdefs_002}
\item \code{nc_p_bdefs_003}
\item \code{nc_p_bdefs_004}
\item \code{nc_p_bdefs_005}
\item \code{nc_p_bdefs_006}
\item \code{nc_p_bdefs_007}
\item \code{nc_p_bdefs_008}
\item \code{nc_p_bdefs_009}
\item \code{nc_p_bdefs_010}
\item \code{nc_p_bdefs_011}
\item \code{nc_p_bdefs_012}
\item \code{nc_p_bdefs_013}
\item \code{nc_p_bdefs_014}
\item \code{nc_p_bdefs_015}
\item \code{nc_p_bdefs_016}
\item \code{nc_p_bdefs_017}
\item \code{nc_p_bdefs_018}
\item \code{nc_p_bdefs_019}
\item \code{nc_p_bdefs_020}
}
}
}
\examples{
\dontrun{
compute_nc_p_bdefs_sum(data) |>
  select(
    data,
    all_of(c("nc_p_bdefs_sum", vars_nc_p_bdefs))
  )
}
}
\keyword{datasets}
