% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARBSQOL_testdata.R
\docType{data}
\name{ABRSQOL_testdata}
\alias{ABRSQOL_testdata}
\title{Test data for ABRSQOL quality of life inversion}
\format{
data.frame with colnames=c('llm_id','w','p_H','P_t','p_n','L','L_b',
'Name','coord_x','coord_y') and 141 observations
}
\source{
\href{https://github.com/Ahlfeldt/ABRSQOL-toolkit}{ABRSQOL-toolkit}
}
\usage{
data(ABRSQOL_testdata)
}
\description{
This is a test data set, and it is not identical to the data used in the
paper. The data set includes average disposable household income as a
measure of wage, the local labour market house price index from Ahlfeldt,
Heblich, Seidel (2023), the 2015 census population as a measure of
residence population and hte 1985 census population as measure of hometown
population. Tradable goods price and local services price indices
are uniformly set to one.
}
\examples{
library('ABRSQOL')
data(ABRSQOL_testdata)
ABRSQOL_testdata$QoL = ABRSQOL(df=ABRSQOL_testdata)
ABRSQOL_testdata
}
\references{
Gabriel M. Ahlfeldt, Fabian Bald, Duncan Roth, Tobias Seidel
(forthcoming): Measuring quality of life under spatial frictions.
}
\keyword{datasets}
