% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_methods.R, R/adlp.R
\name{predict.adlp}
\alias{predict.adlp}
\alias{adlp_func}
\alias{adlp_dens}
\alias{adlp_logS}
\alias{adlp_CRPS}
\alias{adlp_simulate}
\title{Accident and Development period Adjusted Linear Pools (ADLP) Functions}
\usage{
\method{predict}{adlp}(object, newdata = NULL, ...)

adlp_dens(adlp, newdata, model = c("train", "full"))

adlp_logS(adlp, newdata, model = c("train", "full"), epsilon = 1e-06)

adlp_CRPS(
  adlp,
  newdata,
  response_name,
  model = c("train", "full"),
  lower = 1,
  upper = NULL,
  sample_n = 2000
)

adlp_simulate(n, adlp, newdata = NULL)
}
\arguments{
\item{object}{Object of class \code{adlp}}

\item{newdata}{Data to perform the function on}

\item{...}{Other parameters to pass onto predict}

\item{adlp}{Object of class \code{adlp}}

\item{model}{Whether the \code{train} or \code{full} model should be used in function}

\item{epsilon}{Offset added to the density before calculating the log}

\item{response_name}{The column name of the response variable; in string format}

\item{lower}{The lower limit to calculate CRPS; the default value is set to be 1}

\item{upper}{The upper limit to calculate CRPS; the default value is set to be
twice the maximum value of the response variable in the dataset}

\item{sample_n}{The number of evenly spaced values to sample between lower
and upper range of numeric integration used to calculate CRPS. This sample
function is designed to constrain memory usage during the computation of
CRPS, particularly when dealing with large response variables.}

\item{n}{number of simulations}
}
\value{
\code{data.frame} of results, where the first and second columns correspond
to the \verb{$origin} and \verb{$dev} columns from the triangles. An index column for
\code{simulation #} is also included when simulating ADLP.
}
\description{
Family of functions used to support ADLP inference and prediction.
}
\details{
Predicts the central estimates based on the ADLP component models and weights.

Calculates the probability density ad each point, given \code{newdata}.

Calculates the log score, which is the log of the probability density, with
an offset \code{epsilon} to handle zero densities.
Log Score is a strictly proper scoring rule.
For full discussion of the mathematical details and
advantages of Log Score, one might refer to Gneiting and Raftery (2007)

Continuously Ranked Probability Score (CRPS) is calculated for each data point.
\code{lower} and \code{upper} are used as limits when approximating the integral.
CRPS is a strictly proper scoring rule.
For full discussion of the mathematical details and
advantages of CRPS, one might refer to Gneiting and Raftery (2007).
The CRPS function has been discretized in this context to ensure
adaptability to various distributions.
For details, one might refer to
Gneiting and Ranjan (2011)

Simulations of ADLP predictions, given component models and ADLP weights.
}
\examples{
data(test_adlp_component)
test_component1 <- test_adlp_component
test_component2 <- test_adlp_component
test_components <- adlp_components(
    component1 = test_component1,
    component2 = test_component2
)

newdata <- test_component1$model_train$data

test_adlp <- adlp(test_components, newdata = newdata,
    partition_func = adlp_partition_ap, tri.size = 40, size = 3)

test_adlp_dens <- adlp_dens(test_adlp, newdata, "full")

data(test_adlp_component)
test_component1 <- test_adlp_component
test_component2 <- test_adlp_component
test_components <- adlp_components(
    component1 = test_component1,
    component2 = test_component2
)

newdata <- test_component1$model_train$data

test_adlp <- adlp(test_components, newdata = newdata,
    partition_func = adlp_partition_ap, tri.size = 40, size = 3)

test_adlp_logs <- adlp_logS(test_adlp, newdata, "full")

data(test_adlp_component)
test_component1 <- test_adlp_component
test_component2 <- test_adlp_component
test_components <- adlp_components(
    component1 = test_component1,
    component2 = test_component2
)

newdata <- test_component1$model_train$data

test_adlp <- adlp(test_components, newdata = newdata,
    partition_func = adlp_partition_ap, tri.size = 40, size = 3)

test_adlp_crps <- adlp_CRPS(test_adlp, newdata, "full", response_name = "claims", sample_n = 100)

data(test_adlp_component)
test_component1 <- test_adlp_component
test_component2 <- test_adlp_component
test_components <- adlp_components(
    component1 = test_component1,
    component2 = test_component2
)

newdata <- test_component1$model_train$data

test_adlp <- adlp(test_components, newdata = newdata,
    partition_func = adlp_partition_ap, tri.size = 40, size = 3)

test_adlp_sim <- adlp_simulate(10, test_adlp, newdata=newdata)

}
\references{
Gneiting, T., Raftery, A. E., 2007. Strictly proper scoring rules, prediction, and estimation. Journal of the American Statistical Association 102 (477), 359–378.

Gneiting, T., Ranjan, R., 2011. Comparing density forecasts using threshold-and quantile-weighted scoring rules. Journal of Business & Economic Statistics 29 (3), 411–422.
}
