% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_pheno_pair}
\alias{get_pheno_pair}
\title{get_pheno_pair}
\usage{
get_pheno_pair(b, X, r)
}
\arguments{
\item{b}{true effect size matrix of variants on the two phenotypes}

\item{X}{genotype matrix}

\item{r}{phenotypic correlation between the two phenotypes}
}
\value{
A 2x`n_ind` matrix of phenotype information (first row corresponds to the first phenotype, second row corresponds to the second phenotype)
}
\description{
simulation function: simulate true phenotype values of a pair of phenotypes
}
\examples{
AC <- get_ac_mat(n_var=100)
X <- get_geno_mat(AC, n_ind=10000)
b <- get_true_beta(n_var=100, c=0.6, pi=0.5, sigma=1, null=TRUE)
Y <- get_pheno_pair(b=b, X=X, r=0.5)
}
