#' Tea temp requirement for land evaluation
    #' 
    #' A dataset containing the temp characteristics of the crop requirements for farming Tea.
    #' 
    #' @details 
    #' The following are the factors for evaluation: 
#'
    #' \itemize{
#' \item TyAv - Mean annual temperature (°C)
#' \item TmMinAv - Mean min. temp. of warmest month (°C)
#' \item TmMinXm - Avarage minimum temperature of coldest month ( C )
#' \item TmMaxXm - Average max. temp. warmest month (°C)
#' \item TmAv4Xm - Mean temp. of 4 warmest month (°C)
#' }
    #' @seealso 
    #' \itemize{
    #'  \item Yen, B. T., Pheng, K. S., and Hoanh, C. T. (2006). \emph{LUSET: Land Use Suitability Evaluation Tool User's Guide}. International Rice Research Institute.
    #'  }
    #' 
    #' @docType data
    #' @keywords dataset
    #' @format A data frame with 5 rows and 8 columns
#' @name TEATemp
NULL