% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\docType{data}
\name{chapter_14_table_3}
\alias{chapter_14_table_3}
\alias{C14T3}
\alias{Chapter_14_Table_3}
\alias{c14t3}
\title{The data used in Chapter 14, Table 3}
\format{
An object of class \code{data.frame} with 10 rows and 3 columns.
}
\source{
\url{https://designingexperiments.com/data/}

Maxwell, S. E., Delaney, H. D., & Kelley, K. (2018). \emph{Designing experiments and
analyzing data: {A} model comparison perspective}. (3rd ed.). New York, NY: Routledge.
}
\usage{
data(chapter_14_table_3)
}
\description{
The data used in Chapter 14, Table 3
}
\details{
Using the data in Table 14.1, we could average scores for each participant individually because the noise factor we need to average over is a within-subjects factor. For example, participant 1's average 0 degree score is 450, whereas his or her 8 degree score is 630. This participant's reaction time averages 180 msec longer (630 vs 450) for the 8 degree condition than the 0 degree condition. If the other 9 participants' data show a similar pattern, we would infer that there is indeed a main effect due to angle.

For the hypothetical data contained in Table 14.1, Table 14.3 gives the set of D variables. The D variables are subsequently used to analyze the data given in Table 14.1. Recall that we analyzed the data contained in Table 14.1 directly using SPSS without (explicitly) forming D variables. Although obtaining the results of the main effects is easily accomplished using the data directly, forming and then analyzing D variables directly also has its benefits (which are delineated in the chapter). Below we analyze the D variables contained in Table 14.3. As expected, our results will match those previously obtained when we analyzed the raw data (i.e., skipping the step of explicitly forming D variables). However, the method to be outlined here provides a different way to accomplish the same goal. We will soon see that analyzing the data by explicitly forming D variables has its advantages.The first column of Table 14.3 (D1) shows these scores for all 10 participants. Indeed, all 10 participants have an average 8 degree reaction time that is slower than their average 0 degree reaction time. Such consistency strongly supports the existence of an angle main effect.
}
\section{Variables}{

\describe{
\item{d1}{participant D1 difference score averaged over noise}
\item{d2}{participant D2 difference score averaged over noise}
\item{d3}{participant D3 difference score averaged over noise}
}
}

\section{Synonym}{

C14T3
}

\examples{
# Load the data
data(chapter_14_table_3)

# Or, alternatively load the data as
data(C14T3)

# View the structure
str(chapter_14_table_3)

}
\references{
Maxwell, S. E., Delaney, H. D., & Kelley, K. (2018). \emph{Designing experiments and analyzing data:
{A} model comparison perspective} (3rd ed.). New York, NY: Routledge.
}
\author{
Ken Kelley \email{kkelley@nd.edu}
}
\keyword{datasets}
