% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Achilles.R
\name{achilles}
\alias{achilles}
\title{achilles}
\usage{
achilles(
  connectionDetails,
  cdmDatabaseSchema,
  resultsDatabaseSchema = cdmDatabaseSchema,
  scratchDatabaseSchema = resultsDatabaseSchema,
  vocabDatabaseSchema = cdmDatabaseSchema,
  tempEmulationSchema = resultsDatabaseSchema,
  sourceName = "",
  analysisIds,
  createTable = TRUE,
  smallCellCount = 5,
  cdmVersion = "5",
  createIndices = TRUE,
  numThreads = 1,
  tempAchillesPrefix = "tmpach",
  dropScratchTables = TRUE,
  sqlOnly = FALSE,
  outputFolder = "output",
  verboseMode = TRUE,
  optimizeAtlasCache = FALSE,
  defaultAnalysesOnly = TRUE,
  updateGivenAnalysesOnly = FALSE,
  excludeAnalysisIds,
  sqlDialect = NULL
)
}
\arguments{
\item{connectionDetails}{An R object of type \code{connectionDetails} created using the
function \code{createConnectionDetails} in the
\code{DatabaseConnector} package.}

\item{cdmDatabaseSchema}{Fully qualified name of database schema that contains OMOP CDM
schema. On SQL Server, this should specifiy both the database and
the schema, so for example, on SQL Server, 'cdm_instance.dbo'.}

\item{resultsDatabaseSchema}{Fully qualified name of database schema that we can write final
results to. Default is cdmDatabaseSchema. On SQL Server, this
should specifiy both the database and the schema, so for example,
on SQL Server, 'cdm_results.dbo'.}

\item{scratchDatabaseSchema}{Fully qualified name of the database schema that will store all of
the intermediate scratch tables, so for example, on SQL Server,
'cdm_scratch.dbo'. Must be accessible to/from the cdmDatabaseSchema
and the resultsDatabaseSchema. Default is resultsDatabaseSchema.
Making this "#" will run Achilles in single-threaded mode and use
temporary tables instead of permanent tables.}

\item{vocabDatabaseSchema}{String name of database schema that contains OMOP Vocabulary.
Default is cdmDatabaseSchema. On SQL Server, this should specifiy
both the database and the schema, so for example 'results.dbo'.}

\item{tempEmulationSchema}{Formerly oracleTempSchema.  For databases like Oracle where you
must specify the name of the database schema where you want all
temporary tables to be managed. Requires create/insert permissions
to this database.}

\item{sourceName}{String name of the data source name. If blank, CDM_SOURCE table
will be queried to try to obtain this.}

\item{analysisIds}{(OPTIONAL) A vector containing the set of Achilles analysisIds for
which results will be generated. If not specified, all analyses
will be executed. Use \code{\link{getAnalysisDetails}} to get a
list of all Achilles analyses and their Ids.}

\item{createTable}{If true, new results tables will be created in the results schema.
If not, the tables are assumed to already exist, and analysis
results will be inserted (slower on MPP).}

\item{smallCellCount}{To avoid patient identification, cells with small counts (<=
smallCellCount) are deleted. Set to 0 for complete summary without
small cell count restrictions.}

\item{cdmVersion}{Define the OMOP CDM version used: currently supports v5 and above.
Use major release number or minor number only (e.g. 5, 5.3)}

\item{createIndices}{Boolean to determine if indices should be created on the resulting
Achilles tables. Default= TRUE}

\item{numThreads}{(OPTIONAL, multi-threaded mode) The number of threads to use to run
Achilles in parallel. Default is 1 thread.}

\item{tempAchillesPrefix}{(OPTIONAL, multi-threaded mode) The prefix to use for the scratch
Achilles analyses tables. Default is "tmpach"}

\item{dropScratchTables}{(OPTIONAL, multi-threaded mode) TRUE = drop the scratch tables (may
take time depending on dbms), FALSE = leave them in place for later
removal.}

\item{sqlOnly}{Boolean to determine if Achilles should be fully executed. TRUE =
just generate SQL files, don't actually run, FALSE = run Achilles}

\item{outputFolder}{Path to store logs and SQL files}

\item{verboseMode}{Boolean to determine if the console will show all execution steps.
Default = TRUE}

\item{optimizeAtlasCache}{Boolean to determine if the atlas cache has to be optimized.
Default = FALSE}

\item{defaultAnalysesOnly}{Boolean to determine if only default analyses should be run.
Including non-default analyses is substantially more resource
intensive.  Default = TRUE}

\item{updateGivenAnalysesOnly}{Boolean to determine whether to preserve the results of the
analyses NOT specified with the \code{analysisIds} parameter.  To
update only analyses specified by \code{analysisIds}, set
createTable = FALSE and updateGivenAnalysesOnly = TRUE. By default,
updateGivenAnalysesOnly = FALSE, to preserve the original behavior
of Achilles when supplied \code{analysisIds}.}

\item{excludeAnalysisIds}{(OPTIONAL) A vector containing the set of Achilles analyses to
exclude.}

\item{sqlDialect}{(OPTIONAL) String to be used when specifying sqlOnly = TRUE and 
NOT supplying the \code{connectionDetails} parameter. 
if the \code{connectionDetails} parameter is supplied, \code{sqlDialect} 
is ignored.  If the \code{connectionDetails} parameter is not supplied, 
\code{sqlDialect} must be supplied to enable \code{SqlRender} 
to translate properly.  \code{sqlDialect} takes the value normally 
supplied to connectionDetails$dbms.  Default = NULL.}
}
\value{
An object of type \code{achillesResults} containing details for connecting to the database
containing the results
}
\description{
\code{achilles} creates descriptive statistics summary for an entire OMOP CDM instance.
}
\details{
\code{achilles} creates descriptive statistics summary for an entire OMOP CDM instance.
}
\examples{
\dontrun{
connectionDetails <- createConnectionDetails(dbms = "sql server", server = "some_server")
achillesResults <- achilles(connectionDetails = connectionDetails,
  cdmDatabaseSchema = "cdm",
  resultsDatabaseSchema = "results",
  scratchDatabaseSchema = "scratch", 
  sourceName = "Some Source", 
  cdmVersion = "5.3", 
  numThreads = 10, 
  outputFolder = "output")
}

}
