% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABD.R
\name{ABD}
\alias{ABD}
\title{ABD - Age Band Decomposition}
\usage{
ABD(inTRW, min_nTrees_year = 3, pct_stdTRW_th = 0.5, pct_Trees_th = 0.3)
}
\arguments{
\item{inTRW}{tibble. A tibble. The input dataset obtained from
the \code{TRW_readExcel()} function.}

\item{min_nTrees_year}{Numeric. The minimum number of trees per year required within each age class
to be included in the analysis.
The default is 3.
Using less than three trees may result in poor representation of within-class
variability and is not recommended unless data availability is limited.}

\item{pct_stdTRW_th}{Numeric. It defines the threshold for the minimum
proportion of standardized tree-ring width values required within a given
age class.
The default is set to 0.5,
meaning that at least 50\% of the possible
values must be present (e.g., 6 out of 10 values for 10-year age bands,
or 11 out of 20 for 20-year bands).
For instance, the final age band of a 94-year-old tree
(i.e., the 91–100-year band) includes only 4 years of growth.
Since this number of years below the threshold, we recommend
excluding that tree from the corresponding age band group.}

\item{pct_Trees_th}{Numeric. It defines the threshold used to calculate
the mean standardized tree-ring widths within each age band.
The default value is 0.3.
However, when working with small sample sizes (approximately 20 trees or fewer),
it is advisable to increase the threshold to 0.5.
This adjustment helps retain more trees in the analysis while still
accounting for natural growth variability.}
}
\value{
A tibble with the following columns: year, N_ageBands, ABD, and ABDsd.
}
\description{
ABD - Age Band Decomposition. This function calculates
standardized tree-ring width chronologies by decomposing
tree-ring width (stdTRW) data into age bands, detrending
each age band separately, and then recombining them to
produce the mean standardized chronology.
Specifically, ABD standardizes each series within its
age band (e.g., each ring width is divided by the corresponding
age-specific expected value from the stdTRW).
Then, standardized values from all age bands are merged and
averaged to produce a composite chronology, preserving both
inter-annual and low-frequency climate signals.
}
\details{
The function performs age-band decomposition on stdTRW data by filtering out
age classes with insufficient observations (\code{min_nTrees_year}) or
excessive within-class variation.

The \code{stdTRW_th} value is particularly important in small datasets:
too strict a threshold may exclude valid data.
If working with approximately 20 trees or fewer,
a threshold of 0.5 is suggested.

Please, see the \code{Examples} section below for a
demonstration using a typical input tibble obtained with \code{TRW_readExcel()}.
}
\examples{
ABD(inTRW)
}
\seealso{
\code{\link{TRW_readExcel}}, \code{\link{stdTRW}}, \code{\link{plotABD}}

Other ABD functions: 
\code{\link{TRW_readExcel}()},
\code{\link{stdTRW}()}
}
\concept{ABD functions}
