% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_algeria_literacy_rate.R
\name{get_algeria_literacy_rate}
\alias{get_algeria_literacy_rate}
\title{Get Algeria's Adult Literacy Rate}
\source{
World Bank Open Data API: \url{https://data.worldbank.org/indicator/SE.ADT.LITR.ZS}
}
\usage{
get_algeria_literacy_rate()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{indicator}: Indicator name
  \item \code{country}: Country name ("Algeria")
  \item \code{year}: Year of the data (integer)
  \item \code{value}: Literacy rate as a percentage
}
}
\description{
Retrieves Algeria's adult literacy rate (% of people ages 15 and above)
for the years 2010 to 2022 using the World Bank Open Data API.
The indicator used is \code{SE.ADT.LITR.ZS}.
}
\details{
This function sends a GET request to the World Bank API.
If the API request fails or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires internet connection.
}
\examples{
\donttest{
  literacy_data <- get_algeria_literacy_rate()
  head(literacy_data)
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
