% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ames_raw.R
\docType{data}
\name{ames_raw}
\alias{ames_raw}
\alias{ames_geo}
\alias{ames_new}
\alias{hood_levels}
\title{Raw Ames Housing Data}
\source{
De Cock, D. (2011). "Ames, Iowa: Alternative to the Boston Housing Data as an End of Semester Regression Project," \emph{Journal of Statistics Education},  Volume 19, Number 3.

\url{https://ww2.amstat.org/publications/jse/v19n3/decock/DataDocumentation.txt}

\url{http://ww2.amstat.org/publications/jse/v19n3/decock.pdf}
}
\value{
\item{ames_raw}{a tibble}
}
\description{
Summon the data described by De Cock (2011) where 82 fields were recored for 2,930 properties in Ames IA.
}
\details{
From the data documentation reference, the columns include:
\itemize{
\item \code{Order}: Observation number
\item \code{PID}: Parcel identification number  - can be used with city web site for parcel review.
\item \verb{MS SubClass}: Identifies the type of dwelling involved in the sale.
\item \verb{MS Zoning}: Identifies the general zoning classification of the sale.
\item \verb{Lot Frontage}: Linear feet of street connected to property
\item \verb{Lot Area}: Lot size in square feet
\item \code{Street}: Type of road access to property
\item \code{Alley}: Type of alley access to property
\item \verb{Lot Shape}: General shape of property
\item \verb{Land Contour}: Flatness of the property
\item \code{Utilities}: Type of utilities available
\item \verb{Lot Config}: Lot configuration
\item \verb{Land Slope}: Slope of property
\item \code{Neighborhood}: Physical locations within Ames city limits (map available)
\item \verb{Condition 1}: Proximity to various conditions
\item \verb{Condition 2}: Proximity to various conditions (if more than one is present)
\item \verb{Bldg Type}: Type of dwelling
\item \verb{House Style}: Style of dwelling
\item \verb{Overall Qual}: Rates the overall material and finish of the house
\item \verb{Overall Cond}: Rates the overall condition of the house
\item \verb{Year Built}: Original construction date
\item \verb{Year Remod/Add}: Remodel date (same as construction date if no remodeling or additions)
\item \verb{Roof Style}: Type of roof
\item \verb{Roof Matl}: Roof material
\item \verb{Exterior 1}: Exterior covering on house
\item \verb{Exterior 2}: Exterior covering on house (if more than one material)
\item \verb{Mas Vnr Type}: Masonry veneer type
\item \verb{Mas Vnr Area}: Masonry veneer area in square feet
\item \verb{Exter Qual}: Evaluates the quality of the material on the exterior
\item \verb{Exter Cond}: Evaluates the present condition of the material on the exterior
\item \code{Foundation}: Type of foundation
\item \verb{Bsmt Qual}: Evaluates the height of the basement
\item \verb{Bsmt Cond}: Evaluates the general condition of the basement
\item \verb{Bsmt Exposure}: Refers to walkout or garden level walls
\item \verb{BsmtFin Type 1}: Rating of basement finished area
\item \verb{BsmtFin SF 1}: Type 1 finished square feet
\item \verb{BsmtFinType 2}: Rating of basement finished area (if multiple types)
\item \verb{BsmtFin SF 2}: Type 2 finished square feet
\item \verb{Bsmt Unf SF}: Unfinished square feet of basement area
\item \verb{Total Bsmt SF}: Total square feet of basement area
\item \code{Heating}: Type of heating
\item \code{HeatingQC}: Heating quality and condition
\item \verb{Central Air}: Central air conditioning
\item \code{Electrical}: Electrical system
\item \verb{1st Flr SF}: First Floor square feet
\item \verb{2nd Flr SF}: Second floor square feet
\item \verb{Low Qual Fin SF}: Low quality finished square feet (all floors)
\item \verb{Gr Liv Area}: Above grade (ground) living area square feet
\item \verb{Bsmt Full Bath}: Basement full bathrooms
\item \verb{Bsmt Half Bath}: Basement half bathrooms
\item \verb{Full Bath}: Full bathrooms above grade
\item \verb{Half Bath}: Half baths above grade
\item \code{Bedroom}: Bedrooms above grade (does NOT include basement bedrooms)
\item \code{Kitchen}: Kitchens above grade
\item \code{KitchenQual}: Kitchen quality
\item \code{TotRmsAbvGrd}: Total rooms above grade (does not include bathrooms)
\item \code{Functional}: Home functionality (Assume typical unless deductions are warranted)
\item \code{Fireplaces}: Number of fireplaces
\item \code{FireplaceQu}: Fireplace quality
\item \verb{Garage Type}: Garage location
\item \verb{Garage Yr Blt}: Year garage was built
\item \verb{Garage Finish}: Interior finish of the garage
\item \verb{Garage Cars}: Size of garage in car capacity
\item \verb{Garage Area}: Size of garage in square feet
\item \verb{Garage Qual}: Garage quality
\item \verb{Garage Cond}: Garage condition
\item \verb{Paved Drive}: Paved driveway
\item \verb{Wood Deck SF}: Wood deck area in square feet
\item \verb{Open Porch SF}: Open porch area in square feet
\item \verb{Enclosed Porch}: Enclosed porch area in square feet
\item \verb{3-Ssn Porch}: Three season porch area in square feet
\item \verb{Screen Porch}: Screen porch area in square feet
\item \verb{Pool Area}: Pool area in square feet
\item \verb{Pool QC}: Pool quality
\item \code{Fence}: Fence quality
\item \verb{Misc Feature}: Miscellaneous feature not covered in other categories
\item \verb{Misc Val}: $Value of miscellaneous feature
\item \verb{Mo Sold}: Month Sold
\item \verb{Yr Sold}: Year Sold
\item \verb{Sale Type}: Type of sale
\item \verb{Sale Condition}: Condition of sale
}
}
\keyword{datasets}
