% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anchor_regression_gam.R
\name{anchor_regression_gam}
\alias{anchor_regression_gam}
\title{anchor_regression_gam}
\usage{
anchor_regression_gam(x, anchor, gamma, target_variable, bin_factor = NULL)
}
\arguments{
\item{x}{is a dataframe containing the matrix x containing the independent variables}

\item{anchor}{is a dataframe containing the matrix anchor containing the anchor variable}

\item{gamma}{is the regularization parameter for the Anchor Regression}

\item{target_variable}{is the target variable name contained in the x dataframe}

\item{bin_factor}{binary variable that can be transformed to a factor to partial out effects}
}
\value{
A list with coefficient values and a list with the respective names \code{overview_print}. Additionally the transformed data as x and y plus the fixed lambda coefficient.
}
\description{
Perform an Generalized Additive Anchor Regression
}
\examples{
x <- as.data.frame(matrix(data = rnorm(10000),nrow = 1000,ncol = 10))
x$bin <- sample(nrow(x),x = c(1,0),prob = c(0.5,0.5),replace = TRUE)
anchor <- as.data.frame(matrix(data = rnorm(2000),nrow = 1000,ncol = 2))
colnames(anchor) <- c('X1','X2')
gamma <- 2
target_variable <- 'V2'
anchor_regression_gam(x, anchor, gamma, target_variable,bin_factor =  "bin")
}
