% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/element_covariate.R
\name{element_covariate}
\alias{element_covariate}
\title{Calculate Element-Covariate Conditional Probabilities}
\usage{
element_covariate(
  sequences_long,
  element = "element",
  covariate = "covariate",
  n_permutations = 1000
)
}
\arguments{
\item{sequences_long}{A data frame containing the sequences, with columns for elements and covariates.}

\item{element}{A string specifying the column name for elements in the sequences data frame.}

\item{covariate}{A string specifying the column name for covariates in the sequences data frame.}

\item{n_permutations}{An integer specifying the number of permutations for the bootstrapping process.}
}
\value{
A data frame with the calculated probabilities, expected probabilities, and p-values for each element-covariate pair.
}
\description{
This function calculates the conditional probability of each element given each covariate and
performs permutation tests to compute the expected conditional probabilities and p-values.
}
\examples{
# Example usage:
sequences_long <- data.frame(
  element = rep(letters[1:3], each = 4),
  covariate = rep(letters[4:7], times = 3)
)
result <- element_covariate(sequences_long,
                            element = 'element',
                            covariate = 'covariate',
                            n_permutations = 50)
print(result)
}
