% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_length_summary_element.R
\name{sequence_length_summary_element}
\alias{sequence_length_summary_element}
\title{Summarize Sequence Lengths by Element}
\usage{
sequence_length_summary_element(sequences)
}
\arguments{
\item{sequences}{A character vector where each element is a sequence of elements separated by spaces.}
}
\value{
A data frame with the following columns:
\item{element}{The distinct element.}
\item{mean_seq_elements}{The mean length of sequences containing the element.}
\item{sd_seq_elements}{The standard deviation of the lengths of sequences containing the element.}
\item{median_seq_elements}{The median length of sequences containing the element.}
\item{min_seq_elements}{The minimum length of sequences containing the element.}
\item{max_seq_elements}{The maximum length of sequences containing the element.}
\item{distinct_elements}{The number of distinct elements in sequences containing the element.}
\item{pvalue_distinct_elements}{The p-value comparing the true number of distinct elements to shuffled sequences.}
}
\description{
This function calculates summary statistics for the lengths of sequences containing specific distinct elements. It performs the summary for each distinct element found across the sequences.
}
\examples{
sequences <- c('hello world', 'hello world hello', 'hello world hello world')
sequence_length_summary_element(sequences)
}
