% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pattern_recognition_distances.R
\name{Cort}
\alias{Cort}
\title{Temporal correlation coefficient}
\usage{
Cort(S1, S2)
}
\arguments{
\item{S1}{A vector representing a univariate time series}

\item{S2}{A second vector representing a univariate time series}
}
\value{
A coefficient in the interval \eqn{[-1,1]} representing the lag 1 correlation
}
\description{
Return the temporal correlations of two time series by first taking the lag
one differences of each series and the computing the correlation coefficient.
}
\examples{
S1=rnorm(100)
S2=rnorm(100)
Cort(S1, S2)
}
\seealso{
Douzal-Chouakria, Ahlame, and Cecile Amblard. "Classification
Trees for Time Series." Pattern Recognition 45, no. 3 (March 2012):
1076-91. \doi{10.1016/j.patcog.2011.08.018}
}
