% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pattern_recognition_distances.R
\name{DTWcort}
\alias{DTWcort}
\title{Extention of the dynamic time warping distance}
\usage{
DTWcort(k, S1, S2, maxwindow)
}
\arguments{
\item{k}{The parameter $k$ controls the contribution of the sum of squares
comparison as a value-based metric and the $Cort$ quantity as a behavioral
metric; when $k=0$, then the distance is equal to the value-based metric,
on the other hand, when $k=6$ the distance is mainly determined by the value
of the temporal correlation $Cort$.}

\item{S1}{A vector representing a univariate time series}

\item{S2}{A second vector representing a univariate time series}

\item{maxwindow}{the maximum shift allowed between time series points.}
}
\value{
A non-negative value representing the distance between two time
series
}
\description{
This function uses the dtw() function from the dtw R package to compute
a distance based on the mapping than minimizes the distance between two sets
of points, the parameters chosen are the "Manhattan" distance to compute the
differences between points and the "sakoechiba" window type. Important note:
the dtw function does not accept NA values, therefore these types of values
are removed.
}
\examples{
S1=rnorm(100)
S2=rnorm(100)
k=1
maxwindow=20
DTWcort(k,S1, S2,maxwindow)

}
\seealso{
Douzal-Chouakria, Ahlame, and Cecile Amblard. "Classification
Trees for Time Series." Pattern Recognition 45, no. 3 (March 2012):
1076-91. \doi{10.1016/j.patcog.2011.08.018}
}
