% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distance_matrix_knn_algorithm.R
\name{distance_matrix_PMIME}
\alias{distance_matrix_PMIME}
\title{Pairwise distance matrix based on the partial mutual information of mixed
embedings (PMIME) method}
\usage{
distance_matrix_PMIME(unit, Lmax, Tl, nnei, A)
}
\arguments{
\item{unit}{A matrix representing a multivariate time series where each
column is a univariate time series.}

\item{Lmax}{: the maximum delay to search for X and Y components for the mixed
embedding vector ,default is 5.}

\item{Tl}{: Tl steps ahead that the mixed embedding vector has to explain.
Note that if Tl>1 the future vector is of length Tl and contains
the samples at times t+1,..,t+Tl ,dafault is 1.}

\item{nnei}{: number of nearest neighbors for density estimation ,default is 5}

\item{A}{: the threshold for the ratio of CMI over MI of the lagged variables
for the termination criterion.}
}
\value{
a matrix with pairwise distances
}
\description{
Pairwise distance matrix based on the partial mutual information of mixed
embedings (PMIME) method
}
\examples{
X=matrix( rnorm(300), ncol=3  )
Lmax=2
Tl=1
nnei=5
A=.95
distance_matrix_PMIME(unit=X, Lmax, Tl, nnei, A )
}
\seealso{
Kugiumtzis, D. "Direct-Coupling Information Measure from Nonuniform
Embedding." Physical Review E 87, no. 6 (June 25, 2013): 062918.
\doi{10.1103/PhysRevE.87.062918}
}
