% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{Plot.ProbabilityPlot}
\alias{Plot.ProbabilityPlot}
\title{Plot.ProbabilityPlot}
\usage{
Plot.ProbabilityPlot(
  dt = NULL,
  SampleSize = 1000L,
  YVar = NULL,
  YVarTrans = "Identity",
  Height = NULL,
  Width = NULL,
  Title = "Normal Probability Plot",
  ShowLabels = FALSE,
  EchartsTheme = "macarons",
  TextColor = "white",
  title.fontSize = 22,
  title.fontWeight = "bold",
  title.textShadowColor = "#63aeff",
  title.textShadowBlur = 3,
  title.textShadowOffsetY = 1,
  title.textShadowOffsetX = -1,
  yaxis.fontSize = 14,
  yaxis.rotate = 0,
  ContainLabel = TRUE,
  tooltip.trigger = "axis",
  Debug = FALSE
)
}
\arguments{
\item{dt}{source data.table}

\item{SampleSize}{An integer for the number of rows to use. Sampled data is randomized. If NULL then ignored}

\item{YVar}{Y-Axis variable name}

\item{YVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{Height}{"400px"}

\item{Width}{"200px"}

\item{Title}{'Violin Plot'}

\item{ShowLabels}{character}

\item{EchartsTheme}{"macaron"}

\item{TextColor}{'darkblue'}

\item{title.fontSize}{Default 22}

\item{title.fontWeight}{Default "bold"}

\item{title.textShadowColor}{Default '#63aeff'}

\item{title.textShadowBlur}{Default 3}

\item{title.textShadowOffsetY}{Default 1}

\item{title.textShadowOffsetX}{Default -1}

\item{yaxis.fontSize}{Default 14}

\item{yaxis.rotate}{Default 0}

\item{ContainLabel}{Default TRUE}

\item{tooltip.trigger}{Default "axis"}

\item{Debug}{Debugging purposes}
}
\value{
plot
}
\description{
Build a normal probability plot
}
\examples{
# Create fake data
dt <- data.table::data.table(Y = qnorm(p = runif(10000)))

# Create plot
AutoPlots::Plot.ProbabilityPlot(
  dt = dt,
  SampleSize = 1000L,
  YVar = "Y",
  YVarTrans = "Identity",
  Height = NULL,
  Width = NULL,
  Title = 'Normal Probability Plot',
  ShowLabels = FALSE,
  EchartsTheme = "blue",
  TextColor = "black",
  title.fontSize = 22,
  title.fontWeight = "bold",
  title.textShadowColor = '#63aeff',
  title.textShadowBlur = 3,
  title.textShadowOffsetY = 1,
  title.textShadowOffsetX = -1,
  yaxis.fontSize = 14,
  yaxis.rotate = 0,
  ContainLabel = TRUE,
  tooltip.trigger = "axis",
  Debug = FALSE)

}
\seealso{
Other Standard Plots: 
\code{\link{Plot.ACF}()},
\code{\link{Plot.Area}()},
\code{\link{Plot.BarPlot3D}()},
\code{\link{Plot.Bar}()},
\code{\link{Plot.Box}()},
\code{\link{Plot.Copula3D}()},
\code{\link{Plot.Copula}()},
\code{\link{Plot.CorrMatrix}()},
\code{\link{Plot.Density}()},
\code{\link{Plot.Donut}()},
\code{\link{Plot.HeatMap}()},
\code{\link{Plot.Histogram}()},
\code{\link{Plot.Line}()},
\code{\link{Plot.PACF}()},
\code{\link{Plot.Parallel}()},
\code{\link{Plot.Pie}()},
\code{\link{Plot.Radar}()},
\code{\link{Plot.River}()},
\code{\link{Plot.Rosetype}()},
\code{\link{Plot.Scatter3D}()},
\code{\link{Plot.Scatter}()},
\code{\link{Plot.StackedBar}()},
\code{\link{Plot.Step}()},
\code{\link{Plot.WordCloud}()}
}
\author{
Adrian Antico
}
\concept{Standard Plots}
