% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customvision_imgs.R
\name{add_images}
\alias{add_images}
\alias{customvision_images}
\alias{add_images.classification_project}
\alias{add_images.object_detection_project}
\alias{list_images}
\alias{remove_images}
\title{Add, list and remove images for a project}
\usage{
add_images(project, ...)

\method{add_images}{classification_project}(project, images, tags = NULL, ...)

\method{add_images}{object_detection_project}(project, images, regions = NULL, ...)

list_images(project, include = c("all", "tagged", "untagged"),
  as = c("ids", "dataframe", "list"), iteration = NULL)

remove_images(project, image_ids = list_images(project, "untagged", as =
  "ids"), confirm = TRUE)
}
\arguments{
\item{project}{A Custom Vision project.}

\item{...}{Arguments passed to lower-level functions.}

\item{images}{For \code{add_images}, the images to add (upload) to the project.}

\item{tags}{Optional tags to add to the images. Only for classification projects.}

\item{regions}{Optional list of regions in the images that contain objects. Only for object detection projects.}

\item{include}{For \code{list_images}, which images to include in the list: untagged, tagged, or both (the default).}

\item{as}{For \code{list_images}, the return value: a vector of image IDs, a data frame of image metadata, or a list of metadata.}

\item{iteration}{For \code{list_images}, the iteration ID (roughly, which model generation to use). Defaults to the latest iteration.}

\item{image_ids}{For \code{remove_images}, the IDs of the images to remove from the project.}

\item{confirm}{For \code{remove_images}, whether to ask for confirmation first.}
}
\value{
For \code{add_images}, the vector of IDs of the uploaded images.

For \code{list_images}, based on the value of the \code{as} argument. The default is a vector of image IDs; \code{as="list"} returns a (nested) list of image metadata with one component per image; and \code{as="dataframe"} returns the same metadata but reshaped into a data frame.
}
\description{
Add, list and remove images for a project
}
\details{
The images to be uploaded can be specified as:
\itemize{
\item A vector of local filenames. JPG, PNG and GIF file formats are supported.
\item A vector of publicly accessible URLs.
\item A raw vector, or a list of raw vectors, holding the binary contents of the image files.
}

Uploaded images can also have \emph{tags} added (for a classification project) or \emph{regions} (for an object detection project). Classification tags can be specified in the following ways:
\itemize{
\item For a regular classification project (one tag per image), as a vector of strings. The tags will be applied to the images in order. If the length of the vector is 1, it will be recycled to the length of \code{image_ids}.
\item For a multilabel classification project (multiple tags per image), as a \emph{list} of vectors of strings. Each vector in the list contains the tags to be assigned to the corresponding image. If the length of the list is 1, it will be recycled to the length of \code{image_ids}.
}

If the length of the vector is 1, it will be recycled to the length of \code{image_ids}.

Object detection projects also have tags, but they are specified as part of the \code{regions} argument. The regions to add should be specified as a list of data frames, with one data frame per image. Each data frame should have one row per region, and the following columns:
\itemize{
\item \code{left}, \code{top}, \code{width}, \code{height}: the location and dimensions of the region bounding box, normalised to be between 0 and 1.
\item \code{tag}: the name of the tag to associate with the region.
}

Any other columns in the data frame will be ignored. If the length of the list is 1, it will be recycled to the length of \code{image_ids}.

Note that once uploaded, images are identified only by their ID; there is no general link back to the source filename or URL. If you don't include tags or regions in the \code{add_images} call, be sure to save the returned IDs and then call \code{\link{add_image_tags}} or \code{\link{add_image_regions}} as appropriate.
}
\examples{
\dontrun{

endp <- customvision_training_endpoint(url="endpoint_url", key="key")

# classification
proj1 <- create_classification_project(endp, "myproject")
list_images(proj1)
imgs <- dir("path/to/images", full.names=TRUE)

# recycling: apply one tag to all images
add_images(proj1, imgs, tags="mytag")
list_images(proj1, include="tagged", as="dataframe")

# different tags per image
add_images(proj1, c("cat.jpg", "dog.jpg", tags=c("cat", "dog"))

# adding online images
host <- "https://mysite.example.com/"
img_urls <- paste0(host, c("img1.jpg", "img2.jpg", "img3.jpg"))
add_images(proj1, img_urls, tags="mytag")

# multiple label classification
proj2 <- create_classification_project(endp, "mymultilabelproject", multiple_tags=TRUE)

add_images(proj2, imgs, tags=list(c("tag1", "tag2")))
add_images(proj2, c("catanddog.jpg", "cat.jpg", "dog.jpg"),
    tags=list(
        c("cat", "dog"),
        "cat",
        "dog"
    )
)

# object detection
proj3 <- create_object_detection_project(endp, "myobjdetproj")

regions <- list(
    data.frame(
        tag=c("cat", "dog"),
        left=c(0.1, 0.5),
        top=c(0.25, 0.28),
        width=c(0.24, 0.21),
        height=c(0.7, 0.6)
    ),
    data.frame(
        tag="cat", left=0.5, top=0.35, width=0.25, height=0.62
    ),
    data.frame(
        tag="dog", left=0.07, top=0.12, width=0.79, height=0.5
    )
)
add_images(proj3, c("catanddog.jpg", "cat.jpg", "dog.jpg"), regions=regions)

}
}
\seealso{
\code{\link{add_image_tags}} and \code{\link{add_image_regions}} to add tags and regions to images, if not done at upload time

\code{\link{add_tags}}, \code{\link{list_tags}}, \code{\link{remove_tags}}

\code{\link{customvision_project}}
}
