% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customvision.R
\name{create_classification_project}
\alias{create_classification_project}
\alias{customvision_project}
\alias{create_object_detection_project}
\alias{list_projects}
\alias{get_project}
\alias{update_project}
\alias{delete_project}
\title{Create, retrieve, update and delete Azure Custom Vision projects}
\usage{
create_classification_project(endpoint, name, domain = "general",
  export_target = c("none", "standard", "vaidk"), multiple_tags = FALSE,
  description = NULL)

create_object_detection_project(endpoint, name, domain = "general",
  export_target = c("none", "standard", "vaidk"), description = NULL)

list_projects(endpoint)

get_project(endpoint, name = NULL, id = NULL)

update_project(endpoint, name = NULL, id = NULL, domain = "general",
  export_target = c("none", "standard", "vaidk"), multiple_tags = FALSE,
  description = NULL)

delete_project(object, ...)
}
\arguments{
\item{endpoint}{A custom vision endpoint.}

\item{name, id}{The name and ID of the project. At least one of these must be specified for \code{get_project}, \code{update_project} and \code{delete_project}. The name is required for \code{create_project} (the ID will be assigned automatically).}

\item{domain}{What kinds of images the model is meant to apply to. The default "general" means the model is suitable for use in a generic setting. Other, more specialised domains for classification include "food", "landmarks" and "retail"; for object detection the other possible domain is "logo".}

\item{export_target}{What formats are supported when exporting the model.}

\item{multiple_tags}{For classification models, Whether multiple categories (tags/labels) for an image are allowed. The default is \code{FALSE}, meaning an image represents one and only one category. Ignored for object detection models.}

\item{description}{An optional text description of the project.}

\item{object}{For \code{delete_customvision_project}, either an endpoint, or a project object.}

\item{...}{Further arguments passed to lower-level methods.}
}
\value{
\code{delete_project} returns NULL invisibly, on a successful deletion. The others return an object of class \code{customvision_project}.
}
\description{
Create, retrieve, update and delete Azure Custom Vision projects
}
\details{
A Custom Vision project contains the metadata for a model: its intended purpose (classification vs object detection), the domain, the set of training images, and so on. Once you have created a project, you upload images to it, and train models based on those images. A trained model can then be published as a predictive service, or exported for standalone use.

By default, a Custom Vision project does not support exporting the model; this allows it to be more complex, and thus potentially more accurate. Setting \code{export_target="standard"} enables exporting to the following formats:
\itemize{
\item ONNX 1.2
\item CoreML, for iOS 11 devices
\item TensorFlow
\item TensorFlow Lite, for Android devices
\item A Docker image for the Windows, Linux or Raspberry Pi 3 (ARM) platform
}

Setting \code{export_target="vaidk"} allows exporting to Vision AI Development Kit format, in addition to the above.
}
\examples{
\dontrun{

endp <- customvision_training_endpoint(url="endpoint_url", key="key")

create_classification_project(endp, "myproject")
create_classification_project(endp, "mymultilabelproject", multiple_tags=TRUE)
create_object_detection_project(endp, "myobjdetproj")

create_classification_project(endp, "mystdproject", export_target="standard")

list_projects(endp)

get_project(endp, "myproject")

update_project(endp, "myproject", export_target="vaidk")

}
}
\seealso{
\code{\link{customvision_training_endpoint}}, \code{\link{add_images}}, \code{\link{train_model}}, \code{\link{publish_model}}, \code{\link{predict.customvision_model}}, \code{\link{do_training_op}}
\itemize{
\item \href{https://www.customvision.ai/}{CustomVision.ai}: An interactive site for building Custom Vision models, provided by Microsoft
\item \href{https://southcentralus.dev.cognitive.microsoft.com/docs/services/Custom_Vision_Training_3.0/operations/5c771cdcbf6a2b18a0c3b7fa}{Training API reference}
\item \href{https://southcentralus.dev.cognitive.microsoft.com/docs/services/Custom_Vision_Prediction_3.0/operations/5c82db60bf6a2b11a8247c15}{Prediction API reference}
}
}
