% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decision_eval.R
\name{decision_eval}
\alias{decision_eval}
\title{Evaluating a Decision Rule}
\usage{
decision_eval(object, decision.rule, control.range, es, csv.name = NULL)
}
\arguments{
\item{object}{An object of class "BAC".}

\item{decision.rule}{A vector of \code{c(a,b)} specifying the thresholds for
claiming significance (or probabilities of making correct go/no-go decisions
at interim look). See "Details".}

\item{control.range}{A vector of control rates at which the decision rule is
evaluated.}

\item{es}{A vector of treatment arm effect sizes, compared to control arm.}

\item{csv.name}{If a name is specified, the output data set is exported in
CSV format.}
}
\value{
An object of class "BACdecision".
}
\description{
Applies a decision rule to a "BAC" class object and provides rule
 evaluation
}
\details{
The decision rules specified in \code{c(a,b)} may be in the context
 of either interim or final analysis. At the interim, a "go" decision is made
 if the criterion in the "BAC" object exceeds \code{b} and a "no go" decision
 if such criterion is below \code{a}. Otherwise, the decision falls in the
 gray zone.

 For the final analysis, the decision rule should satisfy \code{a}=\code{b}.
 Significance is claimed if the criterion in the "BAC" object exceeds
 \code{a}. Specifying an \code{a} larger than \code{b} will lead to an error.

 For interim analysis, specified decision rule is evaluated by the
 probability of making a correct go or no go decision. For final analysis,
 power or type-I error is computed.

 Negative \code{es} values are allowed if a lower rate is desirable.
}
\examples{
\dontrun{
#borrow from 3 historical trials#
yh = c(11,300,52);nh = c(45,877,128)
#specify current trial sample sizes#
n1 = 20;n2 = 30
obj = BAC_binom(yh=yh,nh=nh,n1=n1,n2=n2,n.chain=5,
criterion.type="prob",prob.threshold=0.1,sim.mode="express")

rule = decision_eval(obj,decision.rule=c(0.05,0.15),
control.range=seq(0.3,0.5,0.01),es=c(0,0.1,0.2),csv.name="result.csv")

#S3 method for class "BACdecision"
plot(rule,interim=T)
}
}
\author{
Hongtao Zhang
}

